/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.fields;

import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.flightrecorder.internal.model.FLRFrame;
import com.jrockit.mc.flightrecorder.internal.model.FLRStackTrace;
import com.jrockit.mc.flightrecorder.provider.Field;
import com.jrockit.mc.flightrecorder.spi.FieldType;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IField;

public final class TopFramePackageField
extends Field {
    private final IField m_field;

    public TopFramePackageField(IEventType type, String attributeIdentifier, IField field) {
        super(type, "(" + attributeIdentifier + ".package)");
        this.m_field = field;
        this.setName("Stacktrace (Top Frame : Package)");
        this.setDescription("The package the method on top of the stack belongs to.");
        this.setFieldType(FieldType.OBJECT);
        this.setContentType(UnitLookup.PACKAGE.getIdentifier());
        this.setVisible(false);
        this.setSynthetic(true);
    }

    @Override
    public Object getValue(IEvent event) {
        FLRStackTrace s;
        FLRFrame frame;
        Object o = this.m_field.getValue(event);
        if (o instanceof FLRStackTrace && (frame = (s = (FLRStackTrace)o).getValidTopFrame()) != null) {
            String packageName = frame.getMethod().getPackageName();
            if (packageName != null && packageName.length() == 0) {
                return "(default package)";
            }
            return packageName;
        }
        return null;
    }
}

