/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.CouldNotLoadRecordingException;
import com.jrockit.mc.flightrecorder.VersionNotSupportedException;
import com.jrockit.mc.flightrecorder.internal.parser.binary.InvalidFlrFileException;
import com.jrockit.mc.flightrecorder.internal.parser.binary.LongParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ShortParser;

public class ChunkHeader {
    private static final short SUPPORTED_MAJOR_VERSION = 0;
    private static final byte[] FLIGHT_RECORDER_MAGIC;
    public static final int CHUNK_HEAD_SIZE;
    private final long chunkPosition;
    private final int chunkIndex;
    private final short majorVersion;
    private final short minorVersion;
    private final int metaDataOffset;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 70;
        byArray[1] = 76;
        byArray[2] = 82;
        FLIGHT_RECORDER_MAGIC = byArray;
        CHUNK_HEAD_SIZE = FLIGHT_RECORDER_MAGIC.length + 4 + 8;
    }

    public ChunkHeader(byte[] chunkHeader, int chunkIndex, long chunkPosition) throws CouldNotLoadRecordingException {
        int i = 0;
        while (i < FLIGHT_RECORDER_MAGIC.length) {
            if (FLIGHT_RECORDER_MAGIC[i] != chunkHeader[i]) {
                throw new InvalidFlrFileException();
            }
            ++i;
        }
        this.majorVersion = ShortParser.readShort(chunkHeader, 4);
        this.minorVersion = ShortParser.readShort(chunkHeader, 6);
        this.metaDataOffset = (int)LongParser.readLong(chunkHeader, 8);
        this.chunkIndex = chunkIndex;
        this.chunkPosition = chunkPosition;
        if (this.metaDataOffset < CHUNK_HEAD_SIZE) {
            throw new InvalidFlrFileException();
        }
        if (this.majorVersion != 0) {
            throw new VersionNotSupportedException();
        }
    }

    public long getChunkPosition() {
        return this.chunkPosition;
    }

    public int getChunkIndex() {
        return this.chunkIndex;
    }

    public int getMetaDataOffset() {
        return this.metaDataOffset;
    }

    public short getMajorVersion() {
        return this.majorVersion;
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }
}

