/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.IOException;
import java.util.WeakHashMap;
import javax.swing.Action;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.IOEvent;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.NbWriter;
import org.netbeans.core.output2.PairMap;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.IOContainer;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class NbIOProvider
extends IOProvider {
    private static final WeakHashMap<IOContainer, PairMap> containerPairMaps = new WeakHashMap();
    private static final String STDOUT = NbBundle.getMessage(NbIOProvider.class, (String)"LBL_STDOUT");
    private static final String NAME = "output2";

    public OutputWriter getStdOut() {
        if (Controller.LOG) {
            Controller.log("NbIOProvider.getStdOut");
        }
        NbIO nbIO = (NbIO)this.getIO(STDOUT, false);
        NbWriter nbWriter = nbIO.writer();
        NbIO.post(new IOEvent(nbIO, 0, true));
        if (nbWriter != null && nbWriter.isClosed()) {
            try {
                nbWriter.reset();
                nbWriter = (NbWriter)nbIO.getOut();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                nbIO = (NbIO)this.getIO(STDOUT, true);
                nbWriter = (NbWriter)nbIO.getOut();
            }
        } else {
            nbWriter = (NbWriter)nbIO.getOut();
        }
        return nbWriter;
    }

    public InputOutput getIO(String string, boolean bl) {
        return this.getIO(string, bl, new Action[0], null);
    }

    public InputOutput getIO(String string, Action[] actionArray) {
        return this.getIO(string, true, actionArray, null);
    }

    public InputOutput getIO(String string, Action[] actionArray, IOContainer iOContainer) {
        return this.getIO(string, true, actionArray, iOContainer);
    }

    public String getName() {
        return NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputOutput getIO(String string, boolean bl, Action[] actionArray, IOContainer iOContainer) {
        NbIO nbIO;
        PairMap pairMap;
        if (Controller.LOG) {
            Controller.log("GETIO: " + string + " new:" + bl);
        }
        IOContainer iOContainer2 = iOContainer == null ? IOContainer.getDefault() : iOContainer;
        WeakHashMap<IOContainer, PairMap> weakHashMap = containerPairMaps;
        synchronized (weakHashMap) {
            pairMap = containerPairMaps.get(iOContainer2);
            nbIO = pairMap != null ? pairMap.get(string) : null;
        }
        if (nbIO == null || bl) {
            nbIO = new NbIO(string, actionArray, iOContainer2);
            weakHashMap = containerPairMaps;
            synchronized (weakHashMap) {
                pairMap = containerPairMaps.get(iOContainer2);
                if (pairMap == null) {
                    pairMap = new PairMap();
                    containerPairMaps.put(iOContainer2, pairMap);
                }
                pairMap.add(string, nbIO);
            }
            NbIO.post(new IOEvent(nbIO, 0, bl));
        }
        return nbIO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dispose(NbIO nbIO) {
        IOContainer iOContainer = nbIO.getIOContainer();
        if (iOContainer == null) {
            iOContainer = IOContainer.getDefault();
        }
        WeakHashMap<IOContainer, PairMap> weakHashMap = containerPairMaps;
        synchronized (weakHashMap) {
            PairMap pairMap = containerPairMaps.get(iOContainer);
            if (pairMap != null) {
                pairMap.remove(nbIO);
                if (pairMap.isEmpty()) {
                    containerPairMaps.remove(iOContainer);
                }
            }
        }
    }
}

