/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.util.Comparator;
import sun.jvm.hotspot.utilities.Interval;
import sun.jvm.hotspot.utilities.RBNode;

public class IntervalNode
extends RBNode {
    private Interval interval;
    private Comparator endpointComparator;
    private Object minEndpoint;
    private Object maxEndpoint;

    public IntervalNode(Interval interval, Comparator endpointComparator, Object data) {
        super(data);
        this.interval = interval;
        this.endpointComparator = endpointComparator;
    }

    @Override
    public void copyFrom(RBNode arg) {
        IntervalNode argNode = (IntervalNode)arg;
        this.interval = argNode.interval;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public Object getMinEndpoint() {
        return this.minEndpoint;
    }

    public Object getMaxEndpoint() {
        return this.maxEndpoint;
    }

    @Override
    public boolean update() {
        Object newMaxEndpoint = this.computeMaxEndpoint();
        Object newMinEndpoint = this.computeMinEndpoint();
        if (this.maxEndpoint != newMaxEndpoint || this.minEndpoint != newMinEndpoint) {
            this.maxEndpoint = newMaxEndpoint;
            this.minEndpoint = newMinEndpoint;
            return true;
        }
        return false;
    }

    public Object computeMinEndpoint() {
        IntervalNode left = (IntervalNode)this.getLeft();
        if (left != null) {
            return left.getMinEndpoint();
        }
        return this.interval.getLowEndpoint();
    }

    public Object computeMaxEndpoint() {
        IntervalNode right;
        IntervalNode left;
        Object curMax = this.interval.getHighEndpoint();
        if (this.getLeft() != null && this.endpointComparator.compare((left = (IntervalNode)this.getLeft()).getMaxEndpoint(), curMax) > 0) {
            curMax = left.getMaxEndpoint();
        }
        if (this.getRight() != null && this.endpointComparator.compare((right = (IntervalNode)this.getRight()).getMaxEndpoint(), curMax) > 0) {
            curMax = right.getMaxEndpoint();
        }
        return curMax;
    }

    public String toString() {
        String res = this.interval.toString();
        Object d = this.getData();
        if (d != null) {
            res = res + " " + d;
        }
        return res;
    }
}

