/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.graph.layout;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.visual.graph.GraphPinScene;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayoutListener;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.Widget;

public abstract class GraphLayout<N, E> {
    private boolean animated = true;
    private final ArrayList<GraphLayoutListener<N, E>> listeners = new ArrayList();

    public final boolean isAnimated() {
        return this.animated;
    }

    public final void setAnimated(boolean bl) {
        this.animated = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addGraphLayoutListener(GraphLayoutListener<N, E> graphLayoutListener) {
        ArrayList<GraphLayoutListener<N, E>> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(graphLayoutListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeGraphLayoutListener(GraphLayoutListener<N, E> graphLayoutListener) {
        ArrayList<GraphLayoutListener<N, E>> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(graphLayoutListener);
        }
    }

    public final void layoutGraph(GraphScene<N, E> graphScene) {
        GraphLayoutListener<N, E>[] graphLayoutListenerArray = this.createListenersCopy();
        UniversalGraph<N, E> universalGraph = UniversalGraph.createUniversalGraph(graphScene);
        for (GraphLayoutListener<N, E> graphLayoutListener : graphLayoutListenerArray) {
            graphLayoutListener.graphLayoutStarted(universalGraph);
        }
        this.performGraphLayout(universalGraph);
        for (GraphLayoutListener<N, E> graphLayoutListener : graphLayoutListenerArray) {
            graphLayoutListener.graphLayoutFinished(universalGraph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <N, E> GraphLayoutListener<N, E>[] createListenersCopy() {
        GraphLayoutListener[] graphLayoutListenerArray;
        ArrayList<GraphLayoutListener<N, E>> arrayList = this.listeners;
        synchronized (arrayList) {
            graphLayoutListenerArray = this.listeners.toArray(new GraphLayoutListener[this.listeners.size()]);
        }
        return graphLayoutListenerArray;
    }

    public final void layoutGraph(GraphPinScene<N, E, ?> graphPinScene) {
        GraphLayoutListener<N, E>[] graphLayoutListenerArray = this.createListenersCopy();
        UniversalGraph<N, E> universalGraph = UniversalGraph.createUniversalGraph(graphPinScene);
        for (GraphLayoutListener<N, E> graphLayoutListener : graphLayoutListenerArray) {
            graphLayoutListener.graphLayoutStarted(universalGraph);
        }
        this.performGraphLayout(universalGraph);
        for (GraphLayoutListener<N, E> graphLayoutListener : graphLayoutListenerArray) {
            graphLayoutListener.graphLayoutFinished(universalGraph);
        }
    }

    public final void layoutNodes(GraphScene<N, E> graphScene, Collection<N> collection) {
        GraphLayoutListener<N, E>[] graphLayoutListenerArray = this.createListenersCopy();
        UniversalGraph<N, E> universalGraph = UniversalGraph.createUniversalGraph(graphScene);
        for (GraphLayoutListener<N, E> graphLayoutListener : graphLayoutListenerArray) {
            graphLayoutListener.graphLayoutStarted(universalGraph);
        }
        this.performNodesLayout(universalGraph, collection);
        for (GraphLayoutListener<N, E> graphLayoutListener : graphLayoutListenerArray) {
            graphLayoutListener.graphLayoutFinished(universalGraph);
        }
    }

    public final void layoutNodes(GraphPinScene<N, E, ?> graphPinScene, Collection<N> collection) {
        GraphLayoutListener<N, E>[] graphLayoutListenerArray = this.createListenersCopy();
        UniversalGraph<N, E> universalGraph = UniversalGraph.createUniversalGraph(graphPinScene);
        for (GraphLayoutListener<N, E> graphLayoutListener : graphLayoutListenerArray) {
            graphLayoutListener.graphLayoutStarted(universalGraph);
        }
        this.performNodesLayout(universalGraph, collection);
        for (GraphLayoutListener<N, E> graphLayoutListener : graphLayoutListenerArray) {
            graphLayoutListener.graphLayoutFinished(universalGraph);
        }
    }

    protected final void setResolvedNodeLocation(UniversalGraph<N, E> universalGraph, N n, Point point) {
        GraphLayoutListener<N, E>[] graphLayoutListenerArray;
        ObjectScene objectScene = universalGraph.getScene();
        Widget widget = objectScene.findWidget(n);
        if (widget == null) {
            return;
        }
        Point point2 = widget.getPreferredLocation();
        if (this.animated) {
            objectScene.getSceneAnimator().animatePreferredLocation(widget, point);
        } else {
            widget.setPreferredLocation(point);
        }
        for (GraphLayoutListener<N, E> graphLayoutListener : graphLayoutListenerArray = this.createListenersCopy()) {
            graphLayoutListener.nodeLocationChanged(universalGraph, n, point2, point);
        }
    }

    protected abstract void performGraphLayout(UniversalGraph<N, E> var1);

    protected abstract void performNodesLayout(UniversalGraph<N, E> var1, Collection<N> var2);
}

