/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.information;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.settings.ListInput;
import com.jrockit.mc.flightrecorder.spi.FieldType;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.ui.common.Toolkit;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.AggregatorFactory;
import com.jrockit.mc.flightrecorder.ui.components.dial.DialDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationContentProvider;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.inputs.InputFactory;
import com.jrockit.mc.flightrecorder.ui.components.selection.BrowseForEventAttributeWizard;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.ui.fields.FieldTableViewer;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.wizards.OnePageWizardDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class AttributeInput
extends ListInput<InformationDescriptor> {
    private final IServiceLocator m_serviceLocator;
    private final InformationDescriptorRepository m_informationDescriptorRepository;

    public AttributeInput(IServiceLocator serviceLocator, InformationDescriptorRepository informationDescriptorRepository) {
        super(Messages.ATTRIBUTE_SUMMARY_CONFIGURATION_TITLE);
        this.m_serviceLocator = serviceLocator;
        this.m_informationDescriptorRepository = informationDescriptorRepository;
    }

    protected List<InformationDescriptor> createDetailList() {
        return this.m_informationDescriptorRepository.getInformationDescriptors();
    }

    protected List<InformationDescriptor> createNew(Shell shell) {
        EventTypeDescriptorRepository eventTypes = this.getEventTypeDescriptorBase();
        if (eventTypes.getDescriptors().isEmpty()) {
            MessageDialog.openConfirm((Shell)shell, (String)Messages.ATTRIBUTE_SUMMARY_CONFIGURATION_MISSING_EVENT_TYPE_TEXT, (String)Messages.ATTRIBUTE_SUMMARY_CONFIGURATION_MUST_SELECT_AT_LEAST_ONE_EVENT_TEXT);
            return null;
        }
        BrowseForEventAttributeWizard bfew = new BrowseForEventAttributeWizard(this.m_serviceLocator, 2, false, this.m_informationDescriptorRepository.getEventTypeDescriptorRepository());
        OnePageWizardDialog dialog = new OnePageWizardDialog(shell, (IWizardPage)bfew);
        dialog.setWidthConstraint(800, Integer.MAX_VALUE);
        dialog.setHeightConstraint(600, 800);
        if (dialog.open() == 0) {
            ArrayList<InformationDescriptor> descs = new ArrayList<InformationDescriptor>();
            Object[] object = bfew.getSelection().toArray();
            if (object.length > 0) {
                Object[] objectArray = object;
                int n = object.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    descs.add(this.createInformationDescriptor((IField)element));
                    ++n2;
                }
            }
            return descs;
        }
        return null;
    }

    private InformationDescriptor createInformationDescriptor(IField field) {
        DialDescriptor informationDescriptor = new DialDescriptor();
        informationDescriptor.setName(field.getName());
        informationDescriptor.setDescription(field.getDescription());
        informationDescriptor.setAttributeIdentifier(field.getIdentifier());
        informationDescriptor.setUnit(Toolkit.createUnit(field));
        if (field.getType() == FieldType.STRING) {
            informationDescriptor.setAggregatorIdentifier(AggregatorFactory.FIRST_VALUE.getIdentifier());
        }
        if ("metadata".equals(field.getContentType())) {
            informationDescriptor.setAggregatorIdentifier(AggregatorFactory.FIRST_VALUE.getIdentifier());
        }
        return informationDescriptor;
    }

    protected StructuredViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, 268503812);
        FieldTableViewer viewer = new FieldTableViewer(table, this.createFields());
        viewer.setContentProvider((IContentProvider)new InformationContentProvider());
        return viewer;
    }

    private EventTypeDescriptorRepository getEventTypeDescriptorBase() {
        return this.m_informationDescriptorRepository.getEventTypeDescriptorRepository();
    }

    protected IInput createTopInput() {
        return InputFactory.createEventTypeInput(this.m_serviceLocator);
    }

    private Field[] createFields() {
        return new Field[]{InformationContentProvider.FIELD_NAME, InformationContentProvider.FIELD_DESCRIPTION};
    }
}

