/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.KindOfQuantity;
import com.jrockit.mc.common.unit.LinearKindOfQuantity;
import com.jrockit.mc.common.unit.LinearUnit;
import com.jrockit.mc.ui.misc.ControlDecorationToolkit;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class QuantityKindProposal {
    private static final int BASE_SCORE = 0x3FFFFFFF;
    private static final IContentProposalProvider EMPTY_PROPOSAL = new SimpleContentProposalProvider(new String[0]);
    private final ContentProposalAdapter adapter;
    private ControlDecoration decorator;

    private QuantityKindProposal(Text text) {
        this.adapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), EMPTY_PROPOSAL, null, null);
        this.adapter.setPopupSize(new Point(150, 300));
        this.adapter.setProposalAcceptanceStyle(2);
    }

    public void setKind(KindOfQuantity<?> kind) {
        if (kind instanceof LinearKindOfQuantity) {
            LinearKindProposalProvider provider = new LinearKindProposalProvider((LinearKindOfQuantity)kind);
            this.adapter.setContentProposalProvider((IContentProposalProvider)provider);
            this.updateDecorator(provider.units);
        } else {
            this.adapter.setContentProposalProvider(EMPTY_PROPOSAL);
            this.updateDecorator(Collections.emptyList());
        }
    }

    public void setUnit(IUnit<?> unit) {
        if (unit instanceof LinearUnit) {
            LinearKindProposalProvider provider = new LinearKindProposalProvider((LinearUnit)unit);
            this.adapter.setContentProposalProvider((IContentProposalProvider)provider);
            this.updateDecorator(provider.units);
        } else {
            this.setKind(unit.getContentType());
        }
    }

    private void updateDecorator(Collection<? extends IUnit<?>> units) {
        if (this.decorator != null) {
            for (IUnit<?> unit : units) {
                if (unit.getLocalizedSymbol().length() <= 0) continue;
                this.decorator.show();
                return;
            }
            this.decorator.hide();
        }
    }

    public void setEnabled(boolean enabled) {
        this.adapter.setEnabled(enabled);
    }

    public static QuantityKindProposal install(Text text) {
        return new QuantityKindProposal(text);
    }

    public static QuantityKindProposal install(Text text, KindOfQuantity<?> kind) {
        QuantityKindProposal quantityKindProposal = QuantityKindProposal.install(text);
        quantityKindProposal.setKind(kind);
        quantityKindProposal.decorator = ControlDecorationToolkit.createContentProposalDecorator((Control)text);
        return quantityKindProposal;
    }

    public boolean isPopupOpen() {
        return this.adapter.isProposalPopupOpen();
    }

    public void addContentProposalListener(IContentProposalListener2 listener) {
        this.adapter.addContentProposalListener(listener);
    }

    public void removeContentProposalListener(IContentProposalListener2 listener) {
        this.adapter.removeContentProposalListener(listener);
    }

    public static class LinearKindProposalProvider
    implements IContentProposalProvider {
        private final Collection<LinearUnit> units;

        public LinearKindProposalProvider(LinearKindOfQuantity kind) {
            this.units = kind.getAllUnits();
        }

        public LinearKindProposalProvider(LinearUnit unit) {
            Collection allUnits = unit.getContentType().getAllUnits();
            if (!allUnits.contains(unit)) {
                ArrayList<LinearUnit> unitList = new ArrayList<LinearUnit>(allUnits.size() + 1);
                unitList.addAll(allUnits);
                unitList.add(unit);
                Collections.sort(unitList);
                this.units = unitList;
            } else {
                this.units = allUnits;
            }
        }

        public IContentProposal[] getProposals(String contents, int position) {
            contents = contents.replace('\u00a0', ' ');
            ParsePosition pos = new ParsePosition(0);
            Number num = LinearKindOfQuantity.getNumberFormat((boolean)true).parse(contents, pos);
            ArrayList<Proposal> proposals = new ArrayList<Proposal>();
            if (num != null) {
                boolean hasEmptyProposal = false;
                String unitPart = contents.substring(pos.getIndex()).trim();
                for (IUnit iUnit : this.units) {
                    int score;
                    String symbol = iUnit.getLocalizedSymbol();
                    if (unitPart.length() == 0) {
                        if (symbol.length() == 0) {
                            score = Integer.MAX_VALUE;
                            hasEmptyProposal = true;
                        } else {
                            score = 0x3FFFFFFF;
                        }
                    } else {
                        score = Math.max(this.matchScore(unitPart, symbol), this.matchScore(unitPart, iUnit.getIdentifier()) - 100);
                        String[] stringArray = iUnit.getAltLocalizedNames();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String unitName = stringArray[n2];
                            score = Math.max(score, this.matchScore(unitPart, unitName));
                            ++n2;
                        }
                    }
                    if (score <= 0) continue;
                    proposals.add(new Proposal(score, String.valueOf(contents.substring(0, pos.getIndex())) + iUnit.getAppendableSuffix(true), symbol, iUnit.getLocalizedDescription()));
                }
                if (hasEmptyProposal && proposals.size() == 1) {
                    return new IContentProposal[0];
                }
            }
            Object[] proposalArr = proposals.toArray(new IContentProposal[proposals.size()]);
            Arrays.sort(proposalArr);
            return proposalArr;
        }

        private int matchScore(String partialUnit, String unitName) {
            if (unitName.startsWith(partialUnit)) {
                return 0x3FFFFFFF + partialUnit.length() - unitName.length() + 3;
            }
            if (unitName.toLowerCase().startsWith(partialUnit.toLowerCase())) {
                return 0x3FFFFFFF + partialUnit.length() - unitName.length();
            }
            return -1073741823;
        }
    }

    private static class Proposal
    extends ContentProposal
    implements Comparable<Proposal> {
        private final int score;

        protected Proposal(int score, String content, String label, String description) {
            super(content, label, description);
            this.score = score;
        }

        @Override
        public int compareTo(Proposal other) {
            return this.score > other.score ? -1 : (this.score == other.score ? 0 : 1);
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

