/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.wizards;

import com.jrockit.mc.ui.misc.AbstractWarningAction;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.wizards.IWizardFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractWizardUserAction
extends AbstractWarningAction
implements IWizardFactory {
    public AbstractWizardUserAction(String name, String description, ImageDescriptor imageDescriptor) {
        super(name, description, imageDescriptor);
    }

    @Override
    public void doExecute() throws Exception {
        final IWizard wizard = this.createWizard();
        if (wizard != null) {
            DisplayToolkit.safeAsyncExec(Display.getDefault(), new Runnable(){

                @Override
                public void run() {
                    WizardDialog dlg = new WizardDialog(Display.getCurrent().getActiveShell(), wizard);
                    dlg.create();
                    dlg.open();
                }
            });
        }
    }

    @Override
    public IWizard createWizard() throws Exception {
        try {
            IWizard wizard = this.doCreateWizard();
            this.resetWarning();
            return wizard;
        }
        catch (Exception e) {
            this.setWarning(e.getLocalizedMessage());
            throw e;
        }
    }

    protected abstract IWizard doCreateWizard() throws Exception;
}

