/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.association.Association;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.javaws.IconUtil;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class MacOSXShortcutInfo {
    private File bundleDirectory;
    private String bundleExecutable;
    private String bundleGetInfoString;
    private String bundleIdentifier;
    private String bundleAppIconPath;
    private String bundleName;
    private String[] launchArgs;
    private static final String BUNDLE_PACKAGE_TYPE = "APPL";
    private static final String BUNDLE_SIGNATURE = "????";
    private static final String DEFAULT_APP_ICON_PATH = "/System/Library/Frameworks/JavaVM.framework/Resources/GenericApp.icns";
    private static final int BEST_ICON_SIZE = 512;
    private static final int MAX_IDENTIFIER_LENGTH = 112;
    private int bundleDocCount;
    private List[] bundleExtensions;
    private List[] bundleMIMETypes;
    private String[] bundleDocIconPathes;
    private String[] bundleDocNames;

    private static String getJnlpLocation(LaunchDesc launchDesc) {
        String string = null;
        File file = ResourceProvider.get().getCachedJNLPFile(launchDesc.getCanonicalHome(), null);
        if (file != null) {
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        return string;
    }

    public MacOSXShortcutInfo(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, File file, List list) throws IOException {
        int n;
        this.bundleDirectory = file;
        Trace.println((String)("bundleDirectory is " + this.bundleDirectory), (TraceLevel)TraceLevel.TEMP);
        this.bundleExecutable = file.getName();
        int n2 = this.bundleExecutable.lastIndexOf(46);
        if (n2 != -1) {
            this.bundleExecutable = this.bundleExecutable.substring(0, n2);
        }
        Trace.println((String)("bundleExecutable is " + this.bundleExecutable), (TraceLevel)TraceLevel.TEMP);
        InformationDesc informationDesc = launchDesc.getInformation();
        String string = informationDesc.getDescription(0);
        String string2 = informationDesc.getDescription(3);
        this.bundleGetInfoString = string2 == null ? string : string2;
        Trace.println((String)("bundleGetInfoString is " + this.bundleGetInfoString), (TraceLevel)TraceLevel.TEMP);
        this.bundleIdentifier = "com.oracle.jnlp-" + launchDesc.getCanonicalHome().hashCode();
        if (this.bundleIdentifier.length() > 112) {
            this.bundleIdentifier = this.bundleIdentifier.substring(0, 112);
        }
        Trace.println((String)("bundleIdentifier is " + this.bundleIdentifier), (TraceLevel)TraceLevel.TEMP);
        this.bundleAppIconPath = IconUtil.getIconPath(launchDesc);
        if (this.bundleAppIconPath == null) {
            this.bundleAppIconPath = Platform.get().getDefaultIconPath();
        }
        if (this.bundleAppIconPath == null) {
            this.bundleAppIconPath = DEFAULT_APP_ICON_PATH;
        }
        Trace.println((String)("bundleAppIconFile is " + this.bundleAppIconPath), (TraceLevel)TraceLevel.TEMP);
        this.bundleName = file.getName();
        this.bundleName = this.bundleName.substring(0, this.bundleName.lastIndexOf(46));
        Trace.println((String)("bundleName is " + this.bundleName), (TraceLevel)TraceLevel.TEMP);
        String string3 = MacOSXShortcutInfo.getJnlpLocation(launchDesc);
        ShortcutDesc shortcutDesc = informationDesc.getShortcut();
        boolean bl = !informationDesc.supportsOfflineOperation() || shortcutDesc == null || shortcutDesc.getOnline();
        String string4 = bl ? "-online" : "-offline";
        String string5 = launchDesc.getLocation() != null ? launchDesc.getLocation().toString() : null;
        String string6 = string5 == null || string5.endsWith(".jarjnlp") ? null : "-J-Djnlp.application.href=" + string5 + " ";
        this.launchArgs = new String[]{"-localfile", string4, string6, string3};
        Trace.println((String)"launchArgs:", (TraceLevel)TraceLevel.TEMP);
        for (n = 0; n < this.launchArgs.length; ++n) {
            Trace.println((String)(" [" + n + "]=" + this.launchArgs[n]), (TraceLevel)TraceLevel.TEMP);
        }
        int n3 = this.bundleDocCount = list != null ? list.size() : 0;
        if (this.bundleDocCount > 0) {
            this.bundleExtensions = new List[this.bundleDocCount];
            this.bundleMIMETypes = new List[this.bundleDocCount];
            this.bundleDocIconPathes = new String[this.bundleDocCount];
            this.bundleDocNames = new String[this.bundleDocCount];
        }
        for (n = 0; n < this.bundleDocCount; ++n) {
            Association association = (Association)list.get(n);
            this.bundleExtensions[n] = association.getFileExtList();
            this.bundleMIMETypes[n] = new ArrayList();
            this.bundleMIMETypes[n].add(association.getMimeType());
            this.bundleDocNames[n] = association.getDescription();
            this.bundleDocIconPathes[n] = association.getIconFileName();
            Trace.println((String)("document type (" + (n + 1) + " of " + this.bundleDocCount + ")"), (TraceLevel)TraceLevel.TEMP);
            Trace.println((String)("     bundleExtensions " + this.bundleExtensions[n]), (TraceLevel)TraceLevel.TEMP);
            Trace.println((String)("     bundleMIMETypes is " + this.bundleMIMETypes[n]), (TraceLevel)TraceLevel.TEMP);
            Trace.println((String)("     bundleDocName is " + this.bundleDocNames[n]), (TraceLevel)TraceLevel.TEMP);
            Trace.println((String)("     bundleDocIconPath is " + this.bundleDocIconPathes[n]), (TraceLevel)TraceLevel.TEMP);
        }
    }

    public File getBundleDirectory() {
        return this.bundleDirectory;
    }

    public String getBundleExecutable() {
        return this.bundleExecutable;
    }

    public String getBundleGetInfoString() {
        return this.bundleGetInfoString;
    }

    public String getBundleAppIconPath() {
        return this.bundleAppIconPath;
    }

    public String getBundleAppIconName() {
        int n = this.bundleAppIconPath.lastIndexOf(File.separatorChar);
        return this.bundleAppIconPath.substring(n + 1);
    }

    public String getBundleIdentifier() {
        return this.bundleIdentifier;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public String getBundlePackageType() {
        return BUNDLE_PACKAGE_TYPE;
    }

    public String getBundleSignature() {
        return BUNDLE_SIGNATURE;
    }

    public String[] getLaunchArgs() {
        return this.launchArgs;
    }

    public int getBundleDocCount() {
        return this.bundleDocCount;
    }

    public List getBundleExtensions(int n) {
        return this.bundleExtensions[n];
    }

    public List getBundleMIMETypes(int n) {
        return this.bundleMIMETypes[n];
    }

    public String getBundleDocIconPath(int n) {
        return this.bundleDocIconPathes[n];
    }

    public String getBundleDocIconName(int n) {
        int n2 = this.bundleDocIconPathes[n].lastIndexOf(File.separatorChar);
        return this.bundleDocIconPathes[n].substring(n2 + 1);
    }

    public String getBundleDocName(int n) {
        return this.bundleDocNames[n];
    }
}

