/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.flightrecorder.CouldNotLoadRecordingException;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ChunkHeader;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ChunkMetadata;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ChunkStructure;
import com.jrockit.mc.flightrecorder.internal.parser.binary.FileReader;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.InvalidFlrFileException;
import com.jrockit.mc.flightrecorder.internal.parser.binary.LoaderContext;
import com.jrockit.mc.flightrecorder.internal.parser.binary.StreamReader;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class FlightRecordingLoader {
    private final List<ChunkStructure> chunks = new ArrayList<ChunkStructure>();
    private final ITimeRange range;
    private int maxChunkSize;
    private final File file;
    private static final ILoadingMonitor NOP_MONITOR = new ILoadingMonitor(){

        @Override
        public void setWorkSize(int totalWork) {
        }

        @Override
        public void doWork(int work) {
        }
    };

    public FlightRecordingLoader(File file) throws CouldNotLoadRecordingException, IOException {
        this.file = file;
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            long nextChunkPos = 0L;
            int chunkIndex = 0;
            long fileLen = raf.length();
            if (fileLen == 0L) {
                throw new InvalidFlrFileException();
            }
            ChunkBuffer buffer = new ChunkBuffer(raf);
            while (nextChunkPos < fileLen) {
                ChunkHeader ch = buffer.readHeader(nextChunkPos, chunkIndex++);
                ChunkStructure structure = buffer.readStructure(ch);
                this.chunks.add(structure);
                nextChunkPos += (long)structure.getChunkSize();
                this.maxChunkSize = Math.max(this.maxChunkSize, structure.getChunkSize());
            }
            ChunkMetadata first = buffer.readMetadata(this.chunks.get(0));
            ChunkMetadata last = buffer.readMetadata(this.chunks.get(this.chunks.size() - 1));
            this.range = new TimeRange(first.getStartTimeNanos(), last.getEndTimeNanos());
        }
        finally {
            IOToolkit.closeSilently((Closeable)raf);
        }
    }

    public ITimeRange getRecordingRange() {
        return this.range;
    }

    public FlightRecording load() throws CouldNotLoadRecordingException, IOException {
        return this.load(null, false, NOP_MONITOR);
    }

    public FlightRecording load(ITimeRange range, boolean showHiddenMethods, ILoadingMonitor monitor) throws CouldNotLoadRecordingException, IOException {
        ExecutorService threadPool = Executors.newCachedThreadPool();
        RandomAccessFile raf = new RandomAccessFile(this.file, "r");
        try {
            Runtime rt = Runtime.getRuntime();
            long availableMemory = rt.maxMemory() - rt.totalMemory() + rt.freeMemory();
            int threadCount = (int)Math.min((long)Math.max(rt.availableProcessors(), 2), Math.max(availableMemory / ((long)this.maxChunkSize * 10L), 1L));
            LoaderContext context = new LoaderContext(monitor, showHiddenMethods, threadCount, this.maxChunkSize);
            if (range == null) {
                monitor.setWorkSize(this.chunks.size());
                threadPool.execute(new FileReader(this.chunks, raf, context, threadPool));
            } else {
                ArrayList<ChunkStructure> filtered = new ArrayList<ChunkStructure>();
                ChunkBuffer metaDataBuffer = new ChunkBuffer(raf);
                for (ChunkStructure c : this.chunks) {
                    ChunkMetadata md = metaDataBuffer.readMetadata(c);
                    if (md.getEndTimeNanos() <= range.getStartTimestamp() || md.getStartTimeNanos() >= range.getEndTimestamp()) continue;
                    filtered.add(c);
                }
                monitor.setWorkSize(filtered.size());
                threadPool.execute(new FileReader(filtered, raf, context, threadPool));
            }
            FlightRecording flightRecording = context.load();
            return flightRecording;
        }
        finally {
            IOToolkit.closeSilently((Closeable)raf);
            threadPool.shutdownNow();
        }
    }

    public static FlightRecording loadFile(File file, boolean showHiddenMethods, ILoadingMonitor monitor) throws CouldNotLoadRecordingException, IOException {
        return new FlightRecordingLoader(file).load(null, showHiddenMethods, monitor);
    }

    public static FlightRecording loadStream(InputStream stream) {
        try {
            return FlightRecordingLoader.loadStream(stream, false, NOP_MONITOR);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static FlightRecording loadStream(InputStream stream, boolean showHiddenMethods, ILoadingMonitor monitor) throws CouldNotLoadRecordingException {
        ExecutorService threadPool = Executors.newCachedThreadPool();
        try {
            Runtime rt = Runtime.getRuntime();
            int threadCount = Math.max(rt.availableProcessors(), 2);
            LoaderContext context = new LoaderContext(monitor, showHiddenMethods, threadCount, ChunkHeader.CHUNK_HEAD_SIZE);
            threadPool.execute(new StreamReader(stream, context, threadPool));
            FlightRecording flightRecording = context.load();
            return flightRecording;
        }
        finally {
            threadPool.shutdownNow();
        }
    }

    public static FlightRecording loadFile(File file) {
        try {
            return FlightRecordingLoader.loadFile(file, false, NOP_MONITOR);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class ChunkBuffer {
        private final RandomAccessFile raf;
        private byte[] buffer;

        ChunkBuffer(RandomAccessFile raf) {
            this.raf = raf;
            this.buffer = new byte[2000];
        }

        void fillBuffer(long position, int length) throws IOException {
            if (length > this.buffer.length) {
                this.buffer = new byte[length];
            }
            this.raf.seek(position);
            this.raf.readFully(this.buffer, 0, length);
        }

        ChunkHeader readHeader(long chunkPos, int chunkIndex) throws IOException, CouldNotLoadRecordingException {
            this.fillBuffer(chunkPos, ChunkHeader.CHUNK_HEAD_SIZE);
            return new ChunkHeader(this.buffer, chunkIndex, chunkPos);
        }

        ChunkStructure readStructure(ChunkHeader ch) throws IOException {
            this.fillBuffer(ch.getChunkPosition() + (long)ch.getMetaDataOffset(), 4);
            int metaDataLength = IntegerParser.readInt(this.buffer, 0);
            return new ChunkStructure(ch, metaDataLength);
        }

        ChunkMetadata readMetadata(ChunkStructure ch) throws IOException, InvalidFlrFileException {
            this.fillBuffer(ch.getHeader().getChunkPosition() + (long)ch.getHeader().getMetaDataOffset(), ch.getMetaDataSize());
            return new ChunkMetadata(this.buffer, 0);
        }
    }

    public static interface ILoadingMonitor {
        public void setWorkSize(int var1);

        public void doWork(int var1);
    }
}

