/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import java.util.Properties;
import org.eclipse.osgi.util.NLS;

public class MRITransformationToolkit {
    private MRITransformationToolkit() {
        throw new AssertionError((Object)"Not to be instantiated!");
    }

    public static MRI getMRI(Properties properties, String name) {
        String mriValue = properties.getProperty(name);
        if (mriValue != null) {
            return MRI.createFromQualifiedName(mriValue);
        }
        return null;
    }

    public static String getTransformationName(MRI mri) {
        String path = mri.getDataPath();
        int partitionIndex = path.indexOf(63);
        if (partitionIndex >= 0) {
            return path.substring(0, partitionIndex);
        }
        return path;
    }

    public static Properties createProperties(MRI mri) {
        Properties properties = new Properties();
        String path = mri.getDataPath();
        int partitionIndex = path.indexOf(63);
        if (partitionIndex >= 0) {
            path = path.substring(partitionIndex + 1);
            String[] stringArray = path.split("&");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String property = stringArray[n2];
                int equalIndex = property.indexOf(61);
                properties.put(property.substring(0, equalIndex), property.substring(equalIndex + 1));
                ++n2;
            }
        }
        return properties;
    }

    public static void forwardMetaData(IMRIMetaDataService metaDataService, MRI mri, IMRIMetaData attributeMetaData, String textPattern) {
        metaDataService.setMetaData(mri, "DisplayName", NLS.bind((String)textPattern, (Object)attributeMetaData.getDisplayName()));
        metaDataService.setMetaData(mri, "Description", NLS.bind((String)textPattern, (Object)attributeMetaData.getDescription()));
        metaDataService.setMetaData(mri, "UpdateTime", attributeMetaData.getUpdateTime());
        metaDataService.setMetaData(mri, "UnitString", attributeMetaData.getUnitString());
    }
}

