/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.layout;

import com.jrockit.mc.common.persistence.History;
import com.jrockit.mc.common.persistence.HistoryState;
import com.jrockit.mc.components.ui.design.DesignerTab;
import com.jrockit.mc.components.ui.design.Operation;
import com.jrockit.mc.components.ui.design.view.layout.HistoryStateContentProvider;
import com.jrockit.mc.components.ui.design.view.layout.HistoryStateLabelProvider;
import com.jrockit.mc.components.ui.design.view.layout.LayoutSubPart;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchSite;

public final class HistoryPart
extends LayoutSubPart {
    private final ISelectionChangedListener m_listener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            HistoryPart.this.select((IStructuredSelection)event.getSelection());
        }
    };
    private TableViewer m_viewer;

    public HistoryPart(IWorkbenchSite site) {
        super(site);
    }

    @Override
    protected void enableControl() {
        this.m_viewer.getControl().setEnabled(true);
    }

    @Override
    protected void disableControl() {
        this.m_viewer.setInput(null);
        this.m_viewer.getControl().setEnabled(false);
    }

    @Override
    protected void updateControl() {
        try {
            this.m_viewer.getControl().setRedraw(false);
            this.m_viewer.setInput(this.getHistory());
            this.m_viewer.refresh();
            this.updateSelection();
        }
        finally {
            this.m_viewer.getControl().setRedraw(true);
        }
    }

    private void updateSelection() {
        HistoryState current;
        History<Operation> history = this.getHistory();
        if (history != null && (current = history.getCurrentState()) != null) {
            this.m_viewer.removeSelectionChangedListener(this.m_listener);
            this.m_viewer.setSelection((ISelection)new StructuredSelection((Object)current), true);
            this.m_viewer.addSelectionChangedListener(this.m_listener);
        }
    }

    @Override
    protected Control createPart(Composite container) {
        this.m_viewer = new TableViewer(container, 67584);
        new TableColumn(this.m_viewer.getTable(), 0);
        TableLayout tl = new TableLayout();
        tl.addColumnData((ColumnLayoutData)new ColumnWeightData(1));
        this.m_viewer.getTable().setLayout((Layout)tl);
        this.m_viewer.getTable().setLinesVisible(true);
        this.m_viewer.setContentProvider((IContentProvider)new HistoryStateContentProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new HistoryStateLabelProvider());
        this.m_viewer.addSelectionChangedListener(this.m_listener);
        return this.m_viewer.getControl();
    }

    private void select(IStructuredSelection selection) {
        History<Operation> h;
        HistoryState o = (HistoryState)selection.getFirstElement();
        if (o != null && (h = this.getHistory()) != null) {
            h.setState(o);
            this.m_viewer.removeSelectionChangedListener(this.m_listener);
            h.notifyObservers();
            this.m_viewer.addSelectionChangedListener(this.m_listener);
            this.m_viewer.getControl().forceFocus();
        }
    }

    private History<Operation> getHistory() {
        DesignerTab dt = this.getDesignerTab();
        if (dt != null) {
            return dt.getHistory();
        }
        return null;
    }
}

