/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.internal;

import java.io.IOException;

public class MethodToolkit {
    private static final String TYPE_VOID = Void.TYPE.getName();
    private static final String TYPE_BOOLEAN = Boolean.TYPE.getName();
    private static final String TYPE_BYTE = Byte.TYPE.getName();
    private static final String TYPE_CHAR = Character.TYPE.getName();
    private static final String TYPE_SHORT = Short.TYPE.getName();
    private static final String TYPE_INTEGER = Integer.TYPE.getName();
    private static final String TYPE_LONG = Long.TYPE.getName();
    private static final String TYPE_FLOAT = Float.TYPE.getName();
    private static final String TYPE_DOUBLE = Double.TYPE.getName();
    private static final String[] PRIMITIVE_TYPES = new String[]{TYPE_BOOLEAN, TYPE_BYTE, TYPE_CHAR, TYPE_SHORT, TYPE_INTEGER, TYPE_LONG, TYPE_FLOAT, TYPE_DOUBLE, TYPE_VOID};

    private MethodToolkit() {
    }

    public static Boolean isPrimitive(String typeName) {
        if (typeName != null) {
            String[] stringArray = PRIMITIVE_TYPES;
            int n = PRIMITIVE_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (element.equals(typeName)) {
                    return Boolean.TRUE;
                }
                ++n2;
            }
        }
        return Boolean.FALSE;
    }

    public static String formatQualifiedName(String packageName, String className) {
        return MethodToolkit.formatQualifiedName(packageName, className, '.');
    }

    public static String formatQualifiedName(String packageName, String className, char separator) {
        if (className != null && packageName != null) {
            if ("".equals(packageName)) {
                return className;
            }
            return String.valueOf(packageName) + separator + className;
        }
        return null;
    }

    public static Boolean hasNestedTypes(String className) {
        if (className == null) {
            return Boolean.FALSE;
        }
        return className.indexOf(36) != -1;
    }

    public static String topLevelType(String className) {
        if (className != null) {
            int index = className.indexOf(36);
            if (index == -1) {
                return className;
            }
            return className.substring(0, index);
        }
        return null;
    }

    public static String nestedTypes(String className) {
        if (className != null) {
            int index = className.indexOf(36);
            if (index == -1 && index + 1 < className.length()) {
                return null;
            }
            return className.substring(index + 1);
        }
        return null;
    }

    public static Boolean isArray(String name) {
        if (name == null) {
            return Boolean.FALSE;
        }
        return name.indexOf(91) > 0;
    }

    public static String getTypeName(String qualifiedClass) {
        if (qualifiedClass != null) {
            int lastDot = qualifiedClass.lastIndexOf(46);
            return lastDot > 0 ? qualifiedClass.substring(lastDot + 1) : qualifiedClass;
        }
        return null;
    }

    public static String getPackageName(String qualifiedClass) {
        if (qualifiedClass != null) {
            int lastDot = qualifiedClass.lastIndexOf(46);
            if (lastDot > 0) {
                return qualifiedClass.substring(0, lastDot);
            }
            return "";
        }
        return null;
    }

    public static String getInnermostComponentType(String name) {
        return name.replaceAll("\\[", "").replaceAll("\\]", "");
    }

    public static String formatHumanReadable(boolean showReturnValue, boolean useQualifiedReturnValue, boolean showClassName, boolean useQualifiedClassName, boolean showArguments, boolean useQualifiedArguments) {
        return null;
    }

    public static String refTypeToFieldDescriptor(String refType) {
        return MethodToolkit.isDescOrRefArray(refType) ? refType : String.valueOf('L') + refType + ';';
    }

    public static String binaryNameToCanonical(String binaryName) {
        return binaryName.replace('$', '.');
    }

    public static String refTypeToBinaryJLS(String refType) throws IllegalArgumentException {
        if (refType.length() == 0 || refType.charAt(0) != '[') {
            return refType.replace('/', '.');
        }
        return MethodToolkit.fieldDescToBinaryJLS(refType);
    }

    public static String fieldDescToBinaryJLS(String fieldDesc) throws IllegalArgumentException {
        StringBuilder out = new StringBuilder();
        try {
            MethodToolkit.fieldDescToBinaryJLS(fieldDesc, 0, out);
        }
        catch (IOException e) {
            throw new RuntimeException("Implementation error", e);
        }
        return out.toString();
    }

    public static int fieldDescToBinaryJLS(CharSequence desc, int start, Appendable out) throws IllegalArgumentException, IOException {
        int top = desc.length();
        if (start >= top) {
            throw new IllegalArgumentException("start=" + start + " > in.length()=" + top);
        }
        int pos = start;
        char c = desc.charAt(pos++);
        switch (c) {
            case '[': {
                pos = MethodToolkit.fieldDescToBinaryJLS(desc, pos, out);
                out.append("[]");
                break;
            }
            case 'B': {
                out.append(TYPE_BYTE);
                break;
            }
            case 'C': {
                out.append(TYPE_CHAR);
                break;
            }
            case 'D': {
                out.append(TYPE_DOUBLE);
                break;
            }
            case 'F': {
                out.append(TYPE_FLOAT);
                break;
            }
            case 'I': {
                out.append(TYPE_INTEGER);
                break;
            }
            case 'J': {
                out.append(TYPE_LONG);
                break;
            }
            case 'S': {
                out.append(TYPE_SHORT);
                break;
            }
            case 'Z': {
                out.append(TYPE_BOOLEAN);
                break;
            }
            case 'V': {
                out.append(TYPE_VOID);
                break;
            }
            case 'L': {
                while (pos < top) {
                    if ((c = desc.charAt(pos++)) == ';') {
                        return pos;
                    }
                    out.append(c == '/' ? (char)'.' : (char)c);
                }
                throw new IllegalArgumentException("Class name '" + desc.subSequence(start + 1, pos) + "' in field descriptor not terminated with ';'.");
            }
            default: {
                throw new IllegalArgumentException("The char '" + c + "' is not a valid first char of a field descriptor.");
            }
        }
        return pos;
    }

    public static boolean isDescOrRefArray(String fieldDesc) {
        return fieldDesc.startsWith("[");
    }

    public static boolean isDescPrimitive(String fieldDesc) {
        return fieldDesc.length() == 1;
    }
}

