/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.management.ThreadInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.management.openmbean.CompositeData;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.coderegion.CodeRegionResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.StackTraceSnapshotBuilder;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsSnapshot;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.openide.util.Lookup;

public class LoadedSnapshot {
    private static final Logger LOGGER = Logger.getLogger(LoadedSnapshot.class.getName());
    public static final int SNAPSHOT_TYPE_UNKNOWN = 0;
    public static final int SNAPSHOT_TYPE_CPU = 1;
    public static final int SNAPSHOT_TYPE_CODEFRAGMENT = 2;
    public static final int SNAPSHOT_TYPE_MEMORY_ALLOCATIONS = 4;
    public static final int SNAPSHOT_TYPE_MEMORY_LIVENESS = 8;
    public static final int SNAPSHOT_TYPE_MEMORY_SAMPLED = 16;
    public static final int SNAPSHOT_TYPE_MEMORY = 28;
    public static final String PROFILER_FILE_MAGIC_STRING = "nBpRoFiLeR";
    private static final byte SNAPSHOT_FILE_VERSION_MAJOR = 1;
    private static final byte SNAPSHOT_FILE_VERSION_MINOR = 2;
    private File file;
    private ProfilingSettings settings;
    private Lookup.Provider project = null;
    private ResultsSnapshot snapshot;
    private String userComments = "";
    private boolean saved = false;

    public LoadedSnapshot(ResultsSnapshot resultsSnapshot, ProfilingSettings profilingSettings, File file, Lookup.Provider provider) {
        if (resultsSnapshot == null) {
            throw new IllegalArgumentException();
        }
        if (profilingSettings == null) {
            throw new IllegalArgumentException();
        }
        this.snapshot = resultsSnapshot;
        this.settings = profilingSettings;
        this.file = file;
        this.project = provider;
    }

    private LoadedSnapshot() {
    }

    public void setFile(File file) {
        this.file = file;
        this.saved = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SnapshotResultsWindow.hasSnapshotWindow(LoadedSnapshot.this)) {
                    SnapshotResultsWindow.get(LoadedSnapshot.this).refreshTabName();
                }
            }
        });
    }

    public File getFile() {
        return this.file;
    }

    public Lookup.Provider getProject() {
        return this.project;
    }

    public void setSaved(boolean bl) {
        this.saved = bl;
    }

    public boolean isSaved() {
        return this.saved;
    }

    public void setUserComments(String string) {
        if (!this.userComments.equals(string)) {
            this.userComments = string;
            this.setSaved(false);
        }
    }

    public String getUserComments() {
        return this.userComments;
    }

    public ProfilingSettings getSettings() {
        return this.settings;
    }

    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    public int getType() {
        if (this.snapshot instanceof CPUResultsSnapshot) {
            return 1;
        }
        if (this.snapshot instanceof CodeRegionResultsSnapshot) {
            return 2;
        }
        if (this.snapshot instanceof LivenessMemoryResultsSnapshot) {
            return 8;
        }
        if (this.snapshot instanceof AllocMemoryResultsSnapshot) {
            return 4;
        }
        if (this.snapshot instanceof SampledMemoryResultsSnapshot) {
            return 16;
        }
        throw new IllegalStateException(Bundle.LoadedSnapshot_IllegalSnapshotDataMsg());
    }

    public static LoadedSnapshot loadSnapshot(DataInputStream dataInputStream) throws IOException {
        dataInputStream.mark(100);
        try {
            LoadedSnapshot loadedSnapshot = new LoadedSnapshot();
            if (loadedSnapshot.load(dataInputStream)) {
                return loadedSnapshot;
            }
            return null;
        }
        catch (IOException iOException) {
            if (Bundle.LoadedSnapshot_InvalidSnapshotFileMsg().equals(iOException.getMessage())) {
                dataInputStream.reset();
                return LoadedSnapshot.loadSnapshotFromStackTraces(dataInputStream);
            }
            throw iOException;
        }
    }

    private static LoadedSnapshot loadSnapshotFromStackTraces(DataInputStream dataInputStream) throws IOException {
        CPUResultsSnapshot cPUResultsSnapshot;
        SamplesInputStream samplesInputStream = new SamplesInputStream(dataInputStream);
        StackTraceSnapshotBuilder stackTraceSnapshotBuilder = new StackTraceSnapshotBuilder();
        ThreadsSample threadsSample = samplesInputStream.readSample();
        long l = threadsSample.getTime() / 1000000L;
        while (threadsSample != null) {
            stackTraceSnapshotBuilder.addStacktrace(threadsSample.getTinfos(), threadsSample.getTime());
            threadsSample = samplesInputStream.readSample();
        }
        samplesInputStream.close();
        samplesInputStream = null;
        try {
            cPUResultsSnapshot = stackTraceSnapshotBuilder.createSnapshot(l);
        }
        catch (CPUResultsSnapshot.NoDataAvailableException noDataAvailableException) {
            throw new IOException(noDataAvailableException);
        }
        return new LoadedSnapshot((ResultsSnapshot)cPUResultsSnapshot, ProfilingSettingsPresets.createCPUPreset(), null, null);
    }

    public void setProject(Lookup.Provider provider) {
        this.project = provider;
    }

    static void writeToStream(CPUResultsSnapshot cPUResultsSnapshot, DataOutputStream dataOutputStream) throws IOException {
        LoadedSnapshot loadedSnapshot = new LoadedSnapshot((ResultsSnapshot)cPUResultsSnapshot, ProfilingSettingsPresets.createCPUPreset(), null, null);
        loadedSnapshot.save(dataOutputStream);
    }

    public void save(DataOutputStream dataOutputStream) throws IOException, OutOfMemoryError {
        Properties properties = new Properties();
        this.settings.store((Map)properties);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("save properties: --------------------------------------------------------------");
            LOGGER.finest(this.settings.debug());
            LOGGER.finest("-------------------------------------------------------------------------------");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000000);
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(10000);
        DataOutputStream dataOutputStream3 = new DataOutputStream(byteArrayOutputStream2);
        try {
            this.snapshot.writeToStream(dataOutputStream2);
            dataOutputStream2.flush();
            properties.store(dataOutputStream3, "");
            dataOutputStream3.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byte[] byArray2 = new byte[byArray.length];
            Deflater deflater = new Deflater();
            deflater.setInput(byArray);
            deflater.finish();
            int n = deflater.deflate(byArray2);
            int n2 = byArray.length;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("save version:1.2");
                LOGGER.finest("save type:" + this.getType());
                LOGGER.finest("length of uncompressed snapshot data:" + n2);
                LOGGER.finest("save length of snapshot data:" + n);
                LOGGER.finest("length of settings data:" + byteArrayOutputStream2.size());
            }
            dataOutputStream.writeBytes(PROFILER_FILE_MAGIC_STRING);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeByte(2);
            dataOutputStream.writeInt(this.getType());
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(n2);
            dataOutputStream.write(byArray2, 0, n);
            dataOutputStream.writeInt(byteArrayOutputStream2.size());
            dataOutputStream.write(byteArrayOutputStream2.toByteArray());
            dataOutputStream.writeUTF(this.userComments);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            byteArrayOutputStream = null;
            dataOutputStream2 = null;
            byteArrayOutputStream2 = null;
            dataOutputStream3 = null;
            throw outOfMemoryError;
        }
        finally {
            if (dataOutputStream2 != null) {
                dataOutputStream2.close();
            }
            if (dataOutputStream3 != null) {
                dataOutputStream3.close();
            }
        }
    }

    public String toString() {
        String string = "snapshot = " + this.snapshot.toString();
        String string2 = "file = " + (this.file == null ? "null" : this.file.toString());
        String string3 = "project = " + (this.project == null ? "null" : ProjectUtilities.getDisplayName((Lookup.Provider)this.project));
        return "Loaded Results Snapshot, " + string + ", " + string3 + ", " + string2;
    }

    private static String getCorruptedMessage(IOException iOException) {
        String string = iOException.getMessage();
        if (string == null) {
            if (iOException instanceof EOFException) {
                return Bundle.LoadedSnapshot_SnapshotFileCorruptedReason(Bundle.LoadedSnapshot_SnapshotFileShortMsg());
            }
            return Bundle.LoadedSnapshot_SnapshotFileCorrupted();
        }
        return Bundle.LoadedSnapshot_SnapshotFileCorruptedReason(string);
    }

    private boolean load(DataInputStream dataInputStream) throws IOException {
        try {
            Properties properties = new Properties();
            this.settings = new ProfilingSettings();
            byte[] byArray = new byte[PROFILER_FILE_MAGIC_STRING.length()];
            int n = dataInputStream.read(byArray);
            if (n != PROFILER_FILE_MAGIC_STRING.length() || !PROFILER_FILE_MAGIC_STRING.equals(new String(byArray))) {
                throw new IOException(Bundle.LoadedSnapshot_InvalidSnapshotFileMsg());
            }
            byte by = dataInputStream.readByte();
            byte by2 = dataInputStream.readByte();
            if (by > 1) {
                throw new IOException(Bundle.LoadedSnapshot_SnapshotFileCorruptedReason(Bundle.LoadedSnapshot_UnsupportedSnapshotVersionMsg()));
            }
            int n2 = dataInputStream.readInt();
            if (n2 == -1) {
                throw new IOException(Bundle.LoadedSnapshot_SnapshotFileCorruptedReason(Bundle.LoadedSnapshot_WrongSnapshotTypeMsg()));
            }
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            InflaterInputStream inflaterInputStream = new InflaterInputStream(new SubInputStream(dataInputStream, n3));
            switch (n2) {
                case 1: {
                    this.snapshot = new CPUResultsSnapshot();
                    break;
                }
                case 2: {
                    this.snapshot = new CodeRegionResultsSnapshot();
                    break;
                }
                case 4: {
                    this.snapshot = new AllocMemoryResultsSnapshot();
                    break;
                }
                case 8: {
                    this.snapshot = new LivenessMemoryResultsSnapshot();
                    break;
                }
                case 16: {
                    this.snapshot = new SampledMemoryResultsSnapshot();
                    break;
                }
                default: {
                    throw new IOException(Bundle.LoadedSnapshot_SnapshotFileCorruptedReason(Bundle.LoadedSnapshot_UnrecognizedSnapshotTypeMsg()));
                }
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inflaterInputStream);
            DataInputStream dataInputStream2 = new DataInputStream(bufferedInputStream);
            try {
                this.snapshot.readFromStream(dataInputStream2);
            }
            catch (IOException iOException) {
                throw new IOException(LoadedSnapshot.getCorruptedMessage(iOException));
            }
            int n5 = dataInputStream.readInt();
            byte[] byArray2 = new byte[n5];
            int n6 = dataInputStream.read(byArray2);
            if (n5 != n6) {
                throw new IOException(Bundle.LoadedSnapshot_SnapshotFileCorruptedReason(Bundle.LoadedSnapshot_CannotReadSettingsDataMsg()));
            }
            if (by2 >= 2) {
                this.userComments = dataInputStream.readUTF();
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("load version:" + by + "." + by2);
                LOGGER.finest("load type:" + n2);
                LOGGER.finest("load length of snapshot data:" + n3);
                LOGGER.finest("uncompressed length of snapshot data:" + n4);
                LOGGER.finest("load length of settings data:" + n5);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            DataInputStream dataInputStream3 = new DataInputStream(byteArrayInputStream);
            try {
                properties.load(dataInputStream3);
            }
            catch (IOException iOException) {
                throw new IOException(LoadedSnapshot.getCorruptedMessage(iOException));
            }
            finally {
                dataInputStream3.close();
            }
            this.settings.load((Map)properties);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("load properties: --------------------------------------------------------------");
                LOGGER.finest(this.settings.debug());
                LOGGER.finest("-------------------------------------------------------------------------------");
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ProfilerDialogs.displayError((String)Bundle.LoadedSnapshot_OutOfMemoryLoadingMsg());
            return false;
        }
        return true;
    }

    static final class ThreadsSample {
        private final long time;
        private final ThreadInfo[] tinfos;

        ThreadsSample(long l, Collection<ThreadInfo> collection) {
            this.time = l;
            this.tinfos = collection.toArray(new ThreadInfo[collection.size()]);
        }

        long getTime() {
            return this.time;
        }

        ThreadInfo[] getTinfos() {
            return this.tinfos;
        }
    }

    static class SamplesInputStream {
        static final String ID = "NPSS";
        static final int MAX_SUPPORTED_VERSION = 2;
        int version;
        int samples;
        long lastTimestamp;
        ObjectInputStream in;
        Map<Long, ThreadInfo> threads;

        SamplesInputStream(File file) throws IOException {
            this(new FileInputStream(file));
        }

        SamplesInputStream(InputStream inputStream) throws IOException {
            this.readHeader(inputStream);
            this.in = new ObjectInputStream(new GZIPInputStream(inputStream));
            if (this.version > 1) {
                this.samples = this.in.readInt();
                this.lastTimestamp = this.in.readLong();
            }
            this.threads = new HashMap<Long, ThreadInfo>(128);
        }

        int getSamples() {
            return this.samples;
        }

        long getLastTimestamp() {
            return this.lastTimestamp;
        }

        ThreadsSample readSample() throws IOException {
            ThreadInfo threadInfo;
            Object object;
            int n;
            long l;
            try {
                l = this.in.readLong();
            }
            catch (EOFException eOFException) {
                return null;
            }
            HashMap<Long, ThreadInfo> hashMap = new HashMap<Long, ThreadInfo>(this.threads.size());
            int n2 = this.in.readInt();
            for (n = 0; n < n2; ++n) {
                object = this.in.readLong();
                threadInfo = this.threads.get(object);
                assert (threadInfo != null);
                hashMap.put((Long)object, threadInfo);
            }
            ThreadInfo[] threadInfoArray = new ThreadInfo[this.in.readInt()];
            for (n = 0; n < threadInfoArray.length; ++n) {
                try {
                    object = (CompositeData)this.in.readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException(classNotFoundException);
                }
                threadInfo = ThreadInfo.from((CompositeData)object);
                hashMap.put(threadInfo.getThreadId(), threadInfo);
            }
            this.threads = hashMap;
            return new ThreadsSample(l, this.threads.values());
        }

        void close() throws IOException {
            this.in.close();
        }

        private void readHeader(InputStream inputStream) throws IOException {
            byte[] byArray = new byte[ID.length()];
            inputStream.read(byArray);
            String string = new String(byArray);
            if (!ID.equals(string)) {
                throw new IOException("Invalid header " + string){

                    @Override
                    public String getLocalizedMessage() {
                        return Bundle.MSG_NotNPSSSnapshot();
                    }
                };
            }
            this.version = inputStream.read();
            if (this.version > 2) {
                throw new IOException("NPSS file version " + this.version + " is not supported"){

                    @Override
                    public String getLocalizedMessage() {
                        return Bundle.MSG_UnsupportedSnapshotVersion();
                    }
                };
            }
        }
    }

    private static class SubInputStream
    extends FilterInputStream {
        private int limit;

        private SubInputStream(InputStream inputStream, int n) {
            super(inputStream);
            this.limit = n;
        }

        @Override
        public int available() throws IOException {
            int n = super.available();
            return Math.min(n, this.limit);
        }

        @Override
        public int read() throws IOException {
            if (this.limit == 0) {
                return -1;
            }
            --this.limit;
            return super.read();
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.limit == 0) {
                return -1;
            }
            int n3 = Math.min(n2, this.limit);
            int n4 = super.read(byArray, n, n3);
            this.limit -= n4;
            return n4;
        }

        @Override
        public long skip(long l) throws IOException {
            long l2 = Math.min(l, (long)this.limit);
            long l3 = super.skip(l2);
            this.limit = (int)((long)this.limit - l3);
            return l3;
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

