/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.renderer.coloring;

import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.util.HashMap;
import java.util.Map;

public enum EventColorType {
    GRADIENT_COLOR("gradientColor", Messages.EVENT_COLOR_TYPE_GRADIENT_COLOR_NAME),
    VALUE_COLOR("valueColor", Messages.EVENT_COLOR_TYPE_VALUE_COLOR_NAME),
    EVENT_TYPE_COLOR("eventTypeColor", Messages.EVENT_COLOR_TYPE_EVENT_TYPE_COLOR_NAME);

    private final String m_identifier;
    private final String m_name;

    private EventColorType(String id, String name) {
        this.m_identifier = id;
        this.m_name = name;
    }

    public static EventColorType lookup(String id) {
        EventColorType[] eventColorTypeArray = EventColorType.values();
        int n = eventColorTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EventColorType ect = eventColorTypeArray[n2];
            if (ect.getIdentifier().equals(id)) {
                return ect;
            }
            ++n2;
        }
        return EVENT_TYPE_COLOR;
    }

    public String getIdentifier() {
        return this.m_identifier;
    }

    public static Map<String, String> createMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        EventColorType[] eventColorTypeArray = EventColorType.values();
        int n = eventColorTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EventColorType ect = eventColorTypeArray[n2];
            map.put(ect.getIdentifier(), ect.getName());
            ++n2;
        }
        return map;
    }

    private String getName() {
        return this.m_name;
    }
}

