/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.fields;

import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.Row;
import com.jrockit.mc.ui.model.fields.filtering.ExpressionFactory;
import com.jrockit.mc.ui.model.fields.filtering.IExpression;
import java.text.ParseException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class FieldFilter
extends ViewerFilter {
    public static final char KLEENE_STAR = '*';
    public static final String KLEENE_STAR_STRING = Character.toString('*');
    public volatile String m_filterExpression;
    public volatile Field m_filterField;
    private volatile IExpression m_expression;
    private volatile String m_errorMessage;
    private volatile int m_errorPosition;

    public FieldFilter() {
    }

    public FieldFilter(Field filterField, String expression) {
        this.m_filterField = filterField;
        this.m_filterExpression = expression;
    }

    public void setFilterExpression(String expression) {
        this.m_filterExpression = expression;
        this.updateExpression();
    }

    public boolean hasValidFilter() {
        return this.m_expression != null;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof Row) {
            Row row = (Row)element;
            if (this.hasValidFilter()) {
                Object data = row.COLUMNS[this.m_filterField.INDEX];
                return this.m_expression.evaluate(data);
            }
        }
        return false;
    }

    public void setFilterField(Field field) {
        this.m_filterField = field;
        this.updateExpression();
    }

    private void updateExpression() {
        try {
            this.m_expression = ExpressionFactory.createExpressionForField(this.m_filterField, this.m_filterExpression);
            this.m_errorMessage = null;
            this.m_errorPosition = -1;
        }
        catch (ParseException e) {
            this.m_errorMessage = e.getMessage();
            this.m_expression = null;
            this.m_errorPosition = e.getErrorOffset();
        }
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public int getFirstErrorPosition() {
        return this.m_errorPosition;
    }
}

