/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MCBook
extends Composite {
    private Control m_currentPage = null;

    public MCBook(Composite parent, int style) {
        super(parent, style);
        this.setLayout(new PageBookLayout());
    }

    public void showPageWithData(Object object, String key) {
        Control[] children;
        Control[] controlArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control element = controlArray[n2];
            if (object.equals(element.getData(key))) {
                this.showPage(element);
                return;
            }
            ++n2;
        }
    }

    public void hidePage(Control page) {
        if (page == this.m_currentPage && page.getParent() == this) {
            Control[] controlArray = this.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child != this.m_currentPage) {
                    this.showPage(child);
                    return;
                }
                ++n2;
            }
            this.m_currentPage.setVisible(false);
            this.m_currentPage = null;
        }
    }

    public void showPage(Control page) {
        if (page != this.m_currentPage && page != null && page.getParent() == this) {
            Control oldPage = this.m_currentPage;
            this.m_currentPage = page;
            if (!page.isDisposed()) {
                page.setVisible(true);
                this.layout(true);
            }
            if (oldPage != null && !oldPage.isDisposed()) {
                oldPage.setVisible(false);
            }
        }
    }

    private class PageBookLayout
    extends Layout {
        private PageBookLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Point noneWrappedChildren = this.calculateSize(composite, wHint, hHint, flushCache, false);
            Point wrappedChildren = this.calculateSize(composite, noneWrappedChildren.x, hHint, flushCache, true);
            return new Point(Math.max(noneWrappedChildren.x, wrappedChildren.x), Math.max(noneWrappedChildren.y, wrappedChildren.y));
        }

        private Point calculateSize(Composite composite, int wHint, int hHint, boolean flushCache, boolean wrapped) {
            Control[] children;
            Point max = new Point(0, 0);
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                if (element != null && (0x40 & element.getStyle()) > 0 == wrapped) {
                    Point result = element.computeSize(wHint, hHint, flushCache);
                    if (wHint != -1) {
                        result.x = wHint;
                    }
                    if (hHint != -1) {
                        result.y = hHint;
                    }
                    max.x = Math.max(result.x, max.x);
                    max.y = Math.max(result.y, max.y);
                }
                ++n2;
            }
            return max;
        }

        protected void layout(Composite composite, boolean flushCache) {
            if (MCBook.this.m_currentPage != null) {
                MCBook.this.m_currentPage.setBounds(composite.getClientArea());
            }
        }
    }
}

