/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.openide.awt.HtmlBrowser;

final class ConnectionErrorDlg
extends Box {
    private static final int MaxCharactersPerLineCount = 100;
    private static final String LINK_START = "[URL]";
    private static final String LINK_END = "[/URL]";
    private static final String FIELD_START = "[TTC]";
    private static final String FIELD_END = "[/TTC]";

    private ConnectionErrorDlg(Segment[] segmentArray) {
        super(3);
        this.initComponents(segmentArray);
    }

    static Object get(String string) {
        Segment[] segmentArray = ConnectionErrorDlg.parseMessage(string);
        if (segmentArray != null) {
            return new ConnectionErrorDlg(segmentArray);
        }
        return string;
    }

    static Segment[] parseMessage(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        ArrayList<Segment> arrayList = null;
        do {
            boolean bl;
            int n4;
            if (n2 >= 0) {
                n2 = string.indexOf(LINK_START, n2);
            }
            if (n3 >= 0) {
                n3 = string.indexOf(FIELD_START, n3);
            }
            if (n2 < 0 && n3 < 0 && arrayList == null) {
                return null;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<Segment>();
            }
            int n5 = n;
            if (n2 > n) {
                n5 = n2;
            }
            if (n3 > n && (n2 < 0 || n3 < n2)) {
                n5 = n3;
            }
            if (n2 < 0 && n3 < 0) {
                n5 = string.length();
            }
            if (n5 > n) {
                int n6;
                String string2 = string.substring(n, n5);
                n4 = 0;
                while ((n6 = string2.indexOf(10, n4)) >= 0) {
                    arrayList.add(new Segment(SegmentKind.LABEL, string2.substring(n4, n6), true));
                    n4 = n6 + 1;
                }
                if (n4 < string2.length()) {
                    arrayList.add(new Segment(SegmentKind.LABEL, string2.substring(n4)));
                }
            }
            n = n5;
            boolean bl2 = bl = n2 >= 0 && (n3 < 0 || n2 < n3);
            if (n2 >= 0 && bl && (n4 = string.indexOf(LINK_END, n2 += LINK_START.length())) > 0) {
                arrayList.add(new Segment(SegmentKind.LINK, string.substring(n2, n4)));
                n = n2 = n4 + LINK_END.length();
            }
            if (n3 < 0 || bl || (n4 = string.indexOf(FIELD_END, n3 += FIELD_START.length())) <= 0) continue;
            arrayList.add(new Segment(SegmentKind.FIELD, string.substring(n3, n4)));
            n = n3 = n4 + FIELD_END.length();
        } while (n2 > 0 || n3 > 0 || n < string.length());
        return arrayList.toArray(new Segment[0]);
    }

    private void initComponents(Segment[] segmentArray) {
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        int n = 0;
        while (n < segmentArray.length) {
            int n2 = segmentArray[n].text.length();
            arrayList.add(segmentArray[n++]);
            while (n < segmentArray.length && (n2 += segmentArray[n].text.length()) <= 100) {
                boolean bl = segmentArray[n].eol;
                arrayList.add(segmentArray[n++]);
                if (!bl) continue;
                break;
            }
            this.addLine(arrayList);
            arrayList.clear();
        }
    }

    private void addLine(List<Segment> list) {
        if (list.size() == 1) {
            this.addSegment(this, list.get(0));
        } else {
            Box box = new Box(2);
            if (box.getComponentOrientation().isLeftToRight()) {
                box.setAlignmentX(0.0f);
            } else {
                box.setAlignmentX(1.0f);
            }
            for (Segment segment : list) {
                this.addSegment(box, segment);
            }
            this.add(box);
        }
    }

    private void addSegment(Box box, Segment segment) {
        JComponent jComponent;
        switch (segment.kind) {
            case FIELD: {
                JTextField jTextField = new JTextField(segment.text);
                jTextField.setEditable(false);
                Dimension dimension = jTextField.getPreferredSize();
                jTextField.setMinimumSize(dimension);
                jTextField.setMaximumSize(dimension);
                jTextField.setBorder(new EmptyBorder(jTextField.getBorder().getBorderInsets(jTextField)));
                jComponent = jTextField;
                break;
            }
            case LABEL: {
                jComponent = new JLabel(segment.text);
                break;
            }
            case LINK: {
                String string = UIManager.getBoolean("nb.dark.theme") ? "#A4A4FF" : "#0000FF";
                jComponent = new JLabel("<html><u><font color=\"" + string + "\">" + segment.text + "</font></u></html>");
                Dimension dimension = jComponent.getPreferredSize();
                jComponent.setMinimumSize(dimension);
                jComponent.setMaximumSize(dimension);
                jComponent.setCursor(Cursor.getPredefinedCursor(12));
                try {
                    final URL uRL = new URL(segment.text);
                    jComponent.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent mouseEvent) {
                            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
                        }
                    });
                }
                catch (MalformedURLException malformedURLException) {}
                break;
            }
            default: {
                throw new IllegalStateException("Unknown segment kind: " + (Object)((Object)segment.kind));
            }
        }
        if (jComponent.getComponentOrientation().isLeftToRight()) {
            jComponent.setAlignmentX(0.0f);
        } else {
            jComponent.setAlignmentX(1.0f);
        }
        box.add(jComponent);
    }

    static final class Segment {
        final SegmentKind kind;
        final String text;
        final boolean eol;

        public Segment(SegmentKind segmentKind, String string) {
            this(segmentKind, string, false);
        }

        public Segment(SegmentKind segmentKind, String string, boolean bl) {
            this.kind = segmentKind;
            this.text = string;
            this.eol = bl;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Segment)) {
                return false;
            }
            Segment segment = (Segment)object;
            return this.kind == segment.kind && this.text.equals(segment.text) && this.eol == segment.eol;
        }

        public int hashCode() {
            return this.kind.ordinal() + this.text.hashCode() + (this.eol ? 0x100000 : 0);
        }

        public String toString() {
            return "Segment(" + this.kind.name() + ")[" + this.text + "]" + (this.eol ? "\\n" : "");
        }
    }

    static enum SegmentKind {
        LABEL,
        LINK,
        FIELD;

    }
}

