/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

class DataConsistentFileOutputStream
extends BufferedOutputStream {
    private FileOutputStream fos;
    private long lastConsistentLength;

    public DataConsistentFileOutputStream(File file, boolean bl) throws FileNotFoundException {
        this(file, bl, new FileOutputStream[]{null});
    }

    private DataConsistentFileOutputStream(File file, boolean bl, FileOutputStream[] fileOutputStreamArray) throws FileNotFoundException {
        fileOutputStreamArray[0] = new FileOutputStream(file, bl);
        super(fileOutputStreamArray[0]);
        this.fos = fileOutputStreamArray[0];
        this.lastConsistentLength = bl ? file.length() : 0L;
    }

    @Override
    public synchronized void write(int n) throws IOException {
        super.write(n);
        ++this.lastConsistentLength;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            super.write(byArray, n, n2);
            this.lastConsistentLength += (long)n2;
        }
        catch (IOException iOException) {
            DataConsistentFileOutputStream.truncateFileToConsistentSize(this.fos, this.lastConsistentLength);
            throw iOException;
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        super.flush();
        FileChannel fileChannel = this.fos.getChannel();
        fileChannel.force(true);
    }

    static void truncateFileToConsistentSize(FileOutputStream fileOutputStream, long l) {
        try {
            FileChannel fileChannel = fileOutputStream.getChannel();
            fileChannel.truncate(l);
            fileChannel.force(true);
        }
        catch (IOException iOException) {
            Logger.getLogger(DataConsistentFileOutputStream.class.getName()).log(Level.INFO, "Not able to truncate file to the data consistent size of " + l + " bytes.", iOException);
        }
    }
}

