/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.tab;

import com.jrockit.mc.components.ui.util.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public final class ImageConverter {
    private static final int COLOR_DEPTH_IN_BITS = 24;
    private static final int DATA_VALUES_PER_PIXEL = 4;
    private static final int CHARACTERS_PER_DATA_VALUE = 2;
    private static final int RED_MASK = 255;
    private static final int GREEN_MASK = 65280;
    private static final int BLUE_MASK = 0xFF0000;

    private ImageConverter() {
        throw new Error("Don't.");
    }

    public static ImageDescriptor createImageDescriptor(Image image) {
        ImageDescriptor imageDescriptor = new ImageDescriptor();
        ImageConverter.fillImageDescriptor(imageDescriptor, image.getImageData());
        return imageDescriptor;
    }

    public static void fillImageDescriptor(ImageDescriptor imageDescriptor, ImageData d) {
        imageDescriptor.setHeight(d.height);
        imageDescriptor.setWidth(d.width);
        imageDescriptor.setEncoding("RGBA");
        imageDescriptor.setImageData(ImageConverter.createImageData(d));
    }

    public static ImageDescriptor createDefault(int width, int height) {
        ImageDescriptor id = new ImageDescriptor();
        id.setWidth(width);
        id.setHeight(height);
        id.setEncoding("RGBA");
        StringBuffer buffer = new StringBuffer();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                buffer.append(ImageConverter.createPixel(new RGB(0, 0, 0)));
                buffer.append(ImageConverter.createAlpha(0));
                ++x;
            }
            ++y;
        }
        id.setImageData(buffer.toString());
        return id;
    }

    private static String createImageData(ImageData imageData) {
        StringBuffer buffer = new StringBuffer();
        PaletteData palette = imageData.palette;
        int y = 0;
        while (y < imageData.height) {
            int x = 0;
            while (x < imageData.width) {
                buffer.append(ImageConverter.createPixel(palette.getRGB(imageData.getPixel(x, y))));
                buffer.append(ImageConverter.createAlpha(imageData.getAlpha(x, y)));
                ++x;
            }
            ++y;
        }
        return buffer.toString();
    }

    public static Image createImage(Device device, ImageDescriptor descriptor) {
        int width = descriptor.getWidth();
        int height = descriptor.getHeight();
        if (width != 0 && height != 0) {
            String data = descriptor.getImageData();
            ImageData imageData = new ImageData(width, height, 24, new PaletteData(255, 65280, 0xFF0000));
            if (data.length() / 2 == 4 * width * height) {
                int dataValueIndex = 0;
                while (dataValueIndex < data.length() / 2) {
                    int pixelIndex = dataValueIndex / 4;
                    int x = pixelIndex % width;
                    int y = pixelIndex / width;
                    imageData.setPixel(x, y, ImageConverter.toRGBPixel(ImageConverter.readValue(data, dataValueIndex, 3)));
                    imageData.setAlpha(x, y, ImageConverter.toAlpha(ImageConverter.readValue(data, dataValueIndex + 3, 1)));
                    dataValueIndex += 4;
                }
                return new Image(device, imageData);
            }
        }
        return null;
    }

    private static String readValue(String data, int dataValueIndex, int count) {
        return data.substring(dataValueIndex * 2, 2 * (dataValueIndex + count));
    }

    private static int toAlpha(String s) {
        return ImageConverter.toDecimalFromTwoDigit(s);
    }

    private static int toRGBPixel(String pixelValue) {
        return ImageConverter.toDecimalFromTwoDigit(pixelValue.substring(0, 2)) + 256 * ImageConverter.toDecimalFromTwoDigit(pixelValue.substring(2, 4)) + 65536 * ImageConverter.toDecimalFromTwoDigit(pixelValue.substring(4, 6));
    }

    private static String createAlpha(int alpha) {
        return ImageConverter.toTwoDigitHex(alpha);
    }

    private static String createPixel(RGB rgb) {
        return String.valueOf(ImageConverter.toTwoDigitHex(rgb.red)) + ImageConverter.toTwoDigitHex(rgb.green) + ImageConverter.toTwoDigitHex(rgb.blue);
    }

    private static String toTwoDigitHex(int value) {
        return new String(new char[]{ImageConverter.toOneDigitHex(value / 16), ImageConverter.toOneDigitHex(value % 16)});
    }

    private static char toOneDigitHex(int v) {
        if (v >= 0 && v <= 15) {
            return v < 10 ? (char)(48 + v) : (char)(65 + v - 10);
        }
        throw new IllegalArgumentException("Value not in range.");
    }

    private static int toDecimalFromTwoDigit(String hexValue) {
        if (hexValue.length() == 2) {
            return 16 * ImageConverter.toDecimalFromOneDigit(hexValue.charAt(0)) + ImageConverter.toDecimalFromOneDigit(hexValue.charAt(1));
        }
        throw new IllegalArgumentException("Hex value must have two digit.");
    }

    private static int toDecimalFromOneDigit(char character) {
        if (character >= '0' && character <= '9') {
            return character - 48;
        }
        if (character >= 'A' && character <= 'F') {
            return character - 65 + 10;
        }
        throw new IllegalArgumentException("Not a valid hexadecimal value.");
    }
}

