/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.celleditors;

import com.jrockit.mc.common.unit.DecimalPrefix;
import com.jrockit.mc.common.unit.IPrefix;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.LinearUnit;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.rjmx.subscription.internal.UpdatePolicyToolkit;
import com.jrockit.mc.rjmx.ui.celleditors.Messages;
import com.jrockit.mc.rjmx.ui.celleditors.UnitCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class UpdateIntervalCellEditor
extends UnitCellEditor {
    private static final LinearUnit MILLISECONDS = UnitLookup.TIMESPAN.getUnit((IPrefix)DecimalPrefix.MILLI);

    public UpdateIntervalCellEditor(Composite parent) {
        super(parent);
        this.getProposal().setEnabled(false);
        this.setUnit((IUnit<?>)MILLISECONDS, Integer.class.getName());
    }

    public Control getControl() {
        Object currentValue = super.doGetValue();
        if (currentValue == null || currentValue.equals(-1)) {
            return null;
        }
        return super.getControl();
    }

    @Override
    public void activate() {
        Object currentValue = super.doGetValue();
        if (currentValue == null || currentValue.equals(-1)) {
            this.doSetValue(0);
            this.fireApplyEditorValue();
        } else {
            if (currentValue.equals(0)) {
                this.doSetValue(UpdatePolicyToolkit.getDefaultUpdateInterval());
            }
            this.getProposal().setEnabled(true);
            super.activate();
        }
    }

    public void deactivate() {
        if (this.getProposal() != null) {
            this.getProposal().setEnabled(false);
        }
        super.deactivate();
    }

    @Override
    protected Object doGetValue() {
        return super.doGetValue() == null ? Integer.valueOf(-1) : super.doGetValue();
    }

    @Override
    protected Object parse(String str) throws Exception {
        Integer val = (Integer)super.parse(str);
        if (val <= 0) {
            throw new Exception(Messages.UpdateIntervalCellEditor_INTERVAL_TOO_SMALL);
        }
        return val;
    }
}

