/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.Callback;
import com.jrockit.mc.common.DataSeries;
import com.jrockit.mc.common.DefaultXYData;
import com.jrockit.mc.common.ITimestampedData;
import com.jrockit.mc.common.IXYData;
import com.jrockit.mc.common.environment.OS;
import com.jrockit.mc.common.unit.DisplayUnit;
import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.KindOfQuantity;
import com.jrockit.mc.common.unit.LinearKindOfQuantity;
import com.jrockit.mc.common.unit.LinearUnit;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.greychart.ui.views.ChartCanvas;
import com.jrockit.mc.rjmx.services.MRIDataSeries;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProvider;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.ui.internal.AntiAliasingListener;
import com.jrockit.mc.rjmx.ui.internal.ChartMenuBuilder;
import com.jrockit.mc.rjmx.ui.internal.ChartModel;
import com.jrockit.mc.rjmx.ui.internal.ExportChartAsImage;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.accessibility.AccessibilityConstants;
import com.jrockit.mc.ui.accessibility.FocusTracker;
import com.jrockit.mc.ui.accessibility.MCAccessibleListener;
import com.jrockit.mc.ui.model.fields.NumberField;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import se.hirt.greychart.ChartRenderer;
import se.hirt.greychart.DefaultMetaDataProvider;
import se.hirt.greychart.GreyChart;
import se.hirt.greychart.JChartComponent;
import se.hirt.greychart.SelectionRenderer;
import se.hirt.greychart.SeriesGreyChart;
import se.hirt.greychart.SeriesMetaDataProvider;
import se.hirt.greychart.TickDensity;
import se.hirt.greychart.TickFormatter;
import se.hirt.greychart.XAxis;
import se.hirt.greychart.YAxis;
import se.hirt.greychart.data.RenderingMode;
import se.hirt.greychart.impl.DefaultXYGreyChart;
import se.hirt.greychart.impl.DefaultXYLineRenderer;
import se.hirt.greychart.impl.DefaultYAxis;
import se.hirt.greychart.impl.EmptyTitleRenderer;
import se.hirt.greychart.impl.NanosXAxis;
import se.hirt.greychart.impl.OptimizingProvider;
import se.hirt.greychart.impl.SamplePoint;
import se.hirt.greychart.impl.TimestampFormatter;
import se.hirt.greychart.impl.WorldToDeviceConverter;

public class ChartComposite
extends Composite {
    public static final long ONE_SECOND = 1000000000L;
    public static final long ONE_MINUTE = 60000000000L;
    public static final long ONE_HOUR = 3600000000000L;
    public static final long ONE_DAY = 86400000000000L;
    public static final long ONE_WEEK = 604800000000000L;
    public static final long ONE_YEAR = 31622400000000000L;
    private static final long MINIMUM_WORLD_WIDTH = 1000000000L;
    private static final double WORLD_PADDING = 0.05;
    private static final double ZOOM_FACTOR_MENU_OUT = 2.0;
    private static final double ZOOM_FACTOR_MENU_IN = 0.5;
    private static final double ZOOM_FACTOR_WHEEL_OUT = 1.25;
    private static final double ZOOM_FACTOR_WHEEL_IN = 0.8;
    private static final double ZOOM_MIDDLE = 0.5;
    private static final String DRAW_PROPERTY = "com.jrockit.mc.rjmx.ui.chart.immediatedraw";
    private static final boolean IMMEDIATE_DRAWING;
    private final ChartCanvas chartCanvas;
    private IAction zoomInAction;
    private IAction zoomOutAction;
    private DefaultYAxis yAxis;
    private final ChartModel m_chartModel = new ChartModel();
    private final JChartComponent m_chartPanel;
    private final IMRIMetaDataService m_mds;
    private DefaultXYGreyChart<ITimestampedData> m_chart;
    private long m_worldWidth;
    private long m_worldEnd = System.currentTimeMillis() * 1000L * 1000L;
    private long m_dataStart = Long.MAX_VALUE;
    private long m_dataEnd = Long.MIN_VALUE;
    private boolean m_enableUpdates;
    private final Callback<Boolean> m_enableUpdatesCallback;

    static {
        boolean drawImmediately = System.getProperty(DRAW_PROPERTY) != null ? Boolean.getBoolean(DRAW_PROPERTY) : OS.getType() == OS.Type.MAC;
        IMMEDIATE_DRAWING = drawImmediately;
    }

    public ChartComposite(Composite parent, int style, Callback<Boolean> enableUpdatesCallback, IMRIMetaDataService mds) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.m_chartPanel = this.createChartPanel();
        this.m_mds = mds;
        this.m_enableUpdatesCallback = enableUpdatesCallback;
        this.setupAntiAliasingListener();
        this.setupObservers();
        this.chartCanvas = new ChartCanvas((Composite)this, (JComponent)this.m_chartPanel);
        MenuManager popupMenu = this.createContextMenu();
        this.chartCanvas.setMenu(popupMenu.createContextMenu((Control)this.chartCanvas));
        this.setupAccessibility();
        this.setupMouseTracker();
        this.updateXAxis();
        this.updateYAxis();
        this.hookSelectionListener();
        this.setupMouseWheelListener();
        this.yAxis.setTickDensity(TickDensity.NORMAL);
    }

    public void refresh() {
        if (!this.chartCanvas.isDisposed()) {
            this.zoomInAction.setEnabled(this.m_worldWidth > 1000000000L && !this.m_enableUpdates);
            ((NanosXAxis)this.getChart().getXAxis()).setRange((Number)(this.m_worldEnd - this.m_worldWidth), (Number)this.m_worldEnd);
            this.m_chart.setXAxis(this.m_chart.getXAxis());
            if (IMMEDIATE_DRAWING && this.isVisible() && !this.chartCanvas.getClientArea().isEmpty()) {
                GC gc = new GC((Drawable)this.chartCanvas);
                this.chartCanvas.paint(gc);
                if (this.chartCanvas.isFocusControl()) {
                    FocusTracker.drawFocusOn((Composite)this.chartCanvas, (GC)gc);
                }
                gc.dispose();
            } else {
                this.chartCanvas.redraw();
            }
        }
    }

    private NanosXAxis getXAxis() {
        return (NanosXAxis)this.getChart().getXAxis();
    }

    private void hookSelectionListener() {
        this.chartCanvas.getSelection().addObserver((Observer)new ZoomSelectionListener());
    }

    private void setupMouseWheelListener() {
        this.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                if (!ChartComposite.this.m_enableUpdates) {
                    Rectangle bounds = ChartComposite.this.getXAxis().getRenderedBounds();
                    int x = Math.max(event.x - bounds.x, 0);
                    x = Math.min(x, bounds.width);
                    double location = (double)x / (double)bounds.width;
                    if (event.count < 0) {
                        ChartComposite.this.zoom(1.25, location);
                    } else if (event.count > 0 && ChartComposite.this.zoomInAction.isEnabled()) {
                        ChartComposite.this.zoom(0.8, location);
                    }
                }
            }
        });
    }

    private void setupAntiAliasingListener() {
        final AntiAliasingListener antialiasingListener = new AntiAliasingListener(this.m_chartPanel.getChart());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)antialiasingListener);
            }
        });
        UIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)antialiasingListener);
    }

    private void setupAccessibility() {
        FocusTracker.enableFocusTracking((Composite)this.chartCanvas);
        final MCAccessibleListener accessabilityListener = new MCAccessibleListener();
        accessabilityListener.setComponentType(AccessibilityConstants.COMPONENT_TYPE_GRAPH);
        this.chartCanvas.getAccessible().addAccessibleListener((AccessibleListener)accessabilityListener);
        this.m_chartModel.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                accessabilityListener.setName(ChartComposite.this.m_chartModel.getChartTitle());
            }
        });
    }

    private void setupMouseTracker() {
        this.chartCanvas.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                Rectangle plotArea = ChartComposite.this.m_chartPanel.getRenderedChartBounds();
                if (!ChartComposite.this.m_enableUpdates && plotArea != null) {
                    org.eclipse.swt.graphics.Rectangle clientArea = ChartComposite.this.chartCanvas.getClientArea();
                    int topMargin = plotArea.x + clientArea.x;
                    int leftMargin = plotArea.y + clientArea.y;
                    Point mousePoint = new Point(e.x - topMargin, e.y - leftMargin);
                    SamplePoint closestSample = null;
                    OptimizingProvider closestProvider = null;
                    long distance = Long.MAX_VALUE;
                    OptimizingProvider[] optimizingProviderArray = ChartComposite.this.getChart().getOptimizingProvider().getChildren();
                    int n = optimizingProviderArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Iterator samples;
                        OptimizingProvider provider = optimizingProviderArray[n2];
                        WorldToDeviceConverter yConverter = provider.getYSampleToDeviceConverterFor((YAxis)ChartComposite.this.yAxis);
                        SamplePoint data = ChartComposite.getClosestPoint(yConverter, mousePoint, samples = provider.getSamples(plotArea.width));
                        if (data != null) {
                            long newDistance = ChartComposite.getSquaredDistance(yConverter, data, mousePoint);
                            if (closestSample == null || newDistance < distance) {
                                closestSample = data;
                                closestProvider = provider;
                                distance = newDistance;
                                if (distance == 0L) break;
                            }
                        }
                        ++n2;
                    }
                    if (closestSample != null && closestProvider != null) {
                        WorldToDeviceConverter yConverter = closestProvider.getYSampleToDeviceConverterFor((YAxis)ChartComposite.this.yAxis);
                        DefaultXYData xyData = new DefaultXYData((Object)closestSample.x, (Object)yConverter.getDeviceCoordinate(closestSample.y));
                        ChartComposite.this.getChart().getPlotRenderer().circleValue((IXYData)xyData);
                        MRI mri = ((MRIDataSeries)closestProvider.getDataSeries()).getAttribute();
                        IMRIMetaData metaData = ChartComposite.this.m_mds.getMetaData(mri);
                        IUnit unit = UnitLookup.getUnitOrNull((String)metaData.getUnitString());
                        if (unit != null) {
                            IQuantity quantity = unit.quantity(closestSample.y);
                            ChartComposite.this.chartCanvas.setToolTipText(String.valueOf(MRIMetaDataToolkit.getDisplayName((IMRIMetaDataService)ChartComposite.this.m_mds, (MRI)mri)) + ": " + quantity.displayUsing("verbose") + " (" + metaData.getValueType() + ", " + MBeanPropertiesOrderer.getAttributePath(mri) + ")");
                        } else {
                            ChartComposite.this.chartCanvas.setToolTipText(String.valueOf(MRIMetaDataToolkit.getDisplayName((IMRIMetaDataService)ChartComposite.this.m_mds, (MRI)mri)) + ": " + NumberField.formatNumber((Number)closestSample.y) + " (" + metaData.getValueType() + ", " + MBeanPropertiesOrderer.getAttributePath(mri) + ")");
                        }
                        ChartComposite.this.chartCanvas.redraw();
                    }
                } else {
                    ChartComposite.this.clearCircledValue();
                }
            }

            public void mouseExit(MouseEvent e) {
                ChartComposite.this.clearCircledValue();
            }
        });
    }

    private JChartComponent createChartPanel() {
        DefaultXYGreyChart chart;
        this.m_chart = chart = new DefaultXYGreyChart();
        chart.setTitleRenderer((ChartRenderer)new EmptyTitleRenderer((GreyChart)chart, 10));
        chart.setIndexRenderer(null);
        chart.setAntialiasingEnabled(AntiAliasingListener.isUsingAntialiasing());
        chart.setAutoUpdateOnAxisChange(false);
        chart.setMetaDataProvider((SeriesMetaDataProvider)new DefaultMetaDataProvider(){

            public Color getLineColor(DataSeries<?> ds) {
                MRI mri = ((MRIDataSeries)ds).getAttribute();
                return MRIMetaDataToolkit.getColor((IMRIMetaDataProvider)ChartComposite.this.m_mds.getMetaData(mri));
            }

            public RenderingMode getMode(DataSeries<?> ds) {
                return ChartComposite.this.m_chartModel.getRenderingMode();
            }

            public double getMultiplier(DataSeries<?> ds) {
                MRI mri = ((MRIDataSeries)ds).getAttribute();
                IUnit unit = UnitLookup.getUnitOrNull((String)ChartComposite.this.m_mds.getMetaData(mri).getUnitString());
                if (unit instanceof LinearUnit) {
                    LinearUnit linearUnit = (LinearUnit)unit;
                    LinearKindOfQuantity kind = linearUnit.getContentType();
                    LinearUnit outUnit = kind.getDefaultUnit();
                    return linearUnit.valueFactorTo(outUnit).getMultiplier();
                }
                return 1.0;
            }
        });
        DefaultXYLineRenderer plotRenderer = chart.getPlotRenderer();
        plotRenderer.setUseClip(false);
        plotRenderer.setDrawOnXAxis(true);
        plotRenderer.setExtrapolateMissingData(false);
        NanosXAxis d = new NanosXAxis((SeriesGreyChart)chart);
        d.setFormatter((TickFormatter)TimestampFormatter.createNanoTimestampFormatter());
        chart.setXAxis((XAxis)d);
        chart.getXAxis().setTitle(Messages.ChartComposite_X_AXIS_TITLE);
        this.yAxis = new DefaultYAxis(chart);
        this.yAxis.setPosition(YAxis.Position.LEFT);
        chart.addYAxis((YAxis)this.yAxis);
        return new JChartComponent((GreyChart)chart);
    }

    private void updateXAxis() {
        NanosXAxis xAxis = (NanosXAxis)this.getChart().getXAxis();
        xAxis.setTitle(this.getChartModel().getXAxis().getTitle());
        this.chartCanvas.redraw();
    }

    private <T extends IQuantity> void updateYAxis() {
        ChartModel.RangedAxis axisModel = this.getChartModel().getYAxis();
        DefaultYAxis yAxisLeft = this.getFirstLeftAxis();
        yAxisLeft.setTitle(axisModel.getTitle());
        KindOfQuantity<?> kindOfQuantity = axisModel.getKindOfQuantity();
        if (kindOfQuantity == UnitLookup.MEMORY) {
            yAxisLeft.setContentType("bytes");
        } else {
            yAxisLeft.setContentType("unknown");
        }
        yAxisLeft.setFormatter(new QuantityFormatter(kindOfQuantity));
        switch (axisModel.getRangeType()) {
            case AUTO: {
                yAxisLeft.setAutoRangeEnabled(true);
                yAxisLeft.setAlwaysShowZero(false);
                yAxisLeft.setAutoPadding(0.2);
                break;
            }
            case AUTO_ZERO: {
                yAxisLeft.setAutoRangeEnabled(true);
                yAxisLeft.setAlwaysShowZero(true);
                yAxisLeft.setAutoPadding(0.2);
                break;
            }
            case CUSTOM: {
                yAxisLeft.setAutoRangeEnabled(false);
                yAxisLeft.setAlwaysShowZero(false);
                IUnit outUnit = axisModel.getKindOfQuantity().getDefaultUnit();
                yAxisLeft.setRange((Number)axisModel.getMinValue().doubleValueIn(outUnit), (Number)axisModel.getMaxValue().doubleValueIn(outUnit));
                yAxisLeft.setAutoPadding(0.0);
            }
        }
        this.chartCanvas.redraw();
    }

    private DefaultYAxis getFirstLeftAxis() {
        YAxis[] yAxis;
        YAxis[] yAxisArray = yAxis = this.getChart().getYAxis();
        int n = yAxis.length;
        int n2 = 0;
        while (n2 < n) {
            YAxis y = yAxisArray[n2];
            if (((DefaultYAxis)y).getPosition() == YAxis.Position.LEFT) {
                return (DefaultYAxis)y;
            }
            ++n2;
        }
        return (DefaultYAxis)yAxis[0];
    }

    private void setupObservers() {
        this.getChartModel().getXAxis().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                ChartComposite.this.updateXAxis();
            }
        });
        this.getChartModel().getYAxis().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                ChartComposite.this.updateYAxis();
            }
        });
    }

    public ChartModel getChartModel() {
        return this.m_chartModel;
    }

    private void clearCircledValue() {
        this.getChart().getPlotRenderer().circleValue(null);
        this.chartCanvas.setToolTipText(null);
        this.chartCanvas.redraw();
    }

    public DefaultXYGreyChart<ITimestampedData> getChart() {
        return this.m_chart;
    }

    private static SamplePoint getClosestPoint(WorldToDeviceConverter yConverter, Point mousePoint, Iterator<SamplePoint> s) {
        SamplePoint result = null;
        long distance = Long.MAX_VALUE;
        Iterator<SamplePoint> iter = s;
        while (iter.hasNext()) {
            SamplePoint data = iter.next();
            long tmpDist = ChartComposite.getSquaredDistance(yConverter, data, mousePoint);
            if (tmpDist >= distance) continue;
            distance = tmpDist;
            result = data;
        }
        return result;
    }

    private static long getSquaredDistance(WorldToDeviceConverter yConverter, SamplePoint data, Point mousePoint) {
        long xdiff = data.x - mousePoint.x;
        long ydiff = yConverter.getDeviceCoordinate(data.y) - mousePoint.y;
        return xdiff * xdiff + ydiff * ydiff;
    }

    private MenuManager createContextMenu() {
        MenuManager popupMenu = new MenuManager();
        popupMenu.add(ChartMenuBuilder.createShowMenu(this));
        popupMenu.add(ChartMenuBuilder.createRangeMenu(this.m_chartModel));
        popupMenu.add(ChartMenuBuilder.createLabelDensityMenu(this.yAxis));
        popupMenu.add(ChartMenuBuilder.createRenderingModeMenu(this.m_chartModel));
        popupMenu.add(ChartMenuBuilder.createTitleMenu(this.m_chartModel));
        this.zoomInAction = new Action(Messages.ChartComposite_MENU_ZOOM_IN_TEXT){

            public void run() {
                ChartComposite.this.zoom(0.5, 0.5);
            }
        };
        this.zoomOutAction = new Action(Messages.ChartComposite_MENU_ZOOM_OUT_TEXT){

            public void run() {
                ChartComposite.this.zoom(2.0, 0.5);
            }
        };
        popupMenu.add(this.zoomInAction);
        popupMenu.add(this.zoomOutAction);
        popupMenu.add((IAction)new ExportChartAsImage(this.m_chartPanel));
        return popupMenu;
    }

    public void showLast(long nanoSeconds) {
        this.m_worldWidth = nanoSeconds;
        this.m_enableUpdatesCallback.call((Object)true);
        if (this.m_dataEnd > 0L) {
            this.m_worldEnd = this.m_dataEnd;
        }
        this.refresh();
    }

    public void extendsDataRangeToInclude(long timestamp) {
        this.setDataRange(Math.min(this.m_dataStart, timestamp), Math.max(this.m_dataEnd, timestamp));
    }

    public void setDataRange(long dataStart, long dataEnd) {
        if (dataEnd > 0L && (this.m_enableUpdates || this.m_dataEnd < 0L)) {
            this.m_worldEnd = dataEnd;
        }
        this.m_dataStart = dataStart;
        this.m_dataEnd = dataEnd;
        this.refresh();
    }

    public void setUpdatesEnabled(boolean enabled) {
        this.m_enableUpdates = enabled;
        this.zoomInAction.setEnabled(!enabled);
        this.zoomOutAction.setEnabled(!enabled);
        if (this.m_enableUpdates && this.m_dataEnd > 0L) {
            this.m_worldEnd = this.m_dataEnd;
            this.refresh();
        }
    }

    private void zoom(double factor, double location) {
        if (this.m_dataEnd > this.m_dataStart) {
            double padding = (double)this.m_worldWidth * 0.05;
            long worldStart = this.m_worldEnd - this.m_worldWidth;
            double zoomPoint = (double)worldStart + (double)this.m_worldWidth * location;
            double newWorldEnd = zoomPoint + ((double)this.m_worldEnd - zoomPoint) * factor;
            double newWorldStart = zoomPoint - (zoomPoint - (double)worldStart) * factor;
            this.m_worldEnd = (long)Math.min(Math.max((double)this.m_worldEnd, (double)this.m_dataEnd + padding), newWorldEnd);
            newWorldStart = Math.max(Math.min((double)worldStart, (double)this.m_dataStart - padding), newWorldStart);
            this.m_worldWidth = (long)((double)this.m_worldEnd - newWorldStart);
            this.refresh();
        }
    }

    private static class QuantityFormatter<T extends IQuantity>
    implements TickFormatter {
        private final IUnit<T> outUnit;
        private final DisplayUnit<T> formatter;

        private QuantityFormatter(KindOfQuantity<T> kindOfQuantity) {
            this.outUnit = kindOfQuantity.getDefaultUnit();
            this.formatter = kindOfQuantity.getDefaultDisplayUnit();
        }

        public String getUnitString(Number min, Number max) {
            return "";
        }

        public String format(Number value, Number min, Number max, Number labelDistance) {
            return this.formatter.format((Object)this.outUnit.quantity(value));
        }
    }

    class ZoomSelectionListener
    implements Observer {
        private SelectionRenderer m_selectionRenderer;

        ZoomSelectionListener() {
        }

        @Override
        public void update(Observable o, Object arg) {
            if (ChartComposite.this.m_dataEnd > ChartComposite.this.m_dataStart) {
                if (ChartComposite.this.chartCanvas.getSelection().isFinished() && this.m_selectionRenderer != null && this.m_selectionRenderer.hasValidSelection()) {
                    ChartComposite.this.m_worldEnd = this.m_selectionRenderer.getSelectedEndX().longValue();
                    ChartComposite.this.m_worldWidth = ChartComposite.this.m_worldEnd - this.m_selectionRenderer.getSelectedStartX().longValue();
                    ChartComposite.this.refresh();
                    ChartComposite.this.chartCanvas.setSelectionRenderer(null);
                }
                if (ChartComposite.this.chartCanvas.getSelection().isBeginSelection()) {
                    ChartComposite.this.m_enableUpdatesCallback.call((Object)false);
                    this.m_selectionRenderer = ChartComposite.this.getChart().createSelectionRenderer();
                    ChartComposite.this.chartCanvas.setSelectionRenderer(this.m_selectionRenderer);
                }
            }
        }
    }
}

