/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import com.jrockit.mc.common.util.CompositeKey;
import com.jrockit.mc.flightrecorder.ui.components.graph.LabelFormatter;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public final class LabelDrawer
extends Observable {
    private static final String ELIPSIS = "...";
    private static final int LABEL_MARGIN = 2;
    public static final LabelFormatter BEGINNING = new LabelFormatter(Messages.THREAD_GRAPH_COMPONENT_TRUNCATE_LABEL_BEGINNING){

        @Override
        public String format(String text, int length) {
            return LabelDrawer.ELIPSIS + text.substring(text.length() - (length - LabelDrawer.ELIPSIS.length()));
        }
    };
    public static final LabelFormatter CENTER = new LabelFormatter(Messages.THREAD_GRAPH_COMPONENT_TRUNCATE_LABEL_CENTER){

        @Override
        public String format(String text, int length) {
            int split = length / 2;
            return String.valueOf(text.substring(0, split - 1)) + LabelDrawer.ELIPSIS + text.substring(text.length() - split + 2);
        }
    };
    public static final LabelFormatter END = new LabelFormatter(Messages.THREAD_GRAPH_COMPONENT_TRUNCATE_LABEL_END){

        @Override
        public String format(String text, int length) {
            return String.valueOf(text.substring(0, length - LabelDrawer.ELIPSIS.length())) + LabelDrawer.ELIPSIS;
        }
    };
    private static final int MAX_CACHE_SIZE = 10000;
    private static final int MINIMUM_TEXT_LENGTH = 10;
    private final Map<CompositeKey, JTextArea> m_cache = new HashMap<CompositeKey, JTextArea>();
    private final Font m_font;
    private final int m_rowHeight;
    private LabelFormatter m_labelFormatter = CENTER;

    public LabelDrawer(int rowHeight) {
        this.m_font = UIManager.getFont("Tree.font");
        this.m_rowHeight = rowHeight;
    }

    public void drawLabel(Graphics2D g2, Rectangle drawArea, String name) {
        JTextArea area = this.getTextArea(name, drawArea.width, drawArea.height);
        int xt = drawArea.x + 2;
        int yt = drawArea.y + drawArea.height / 2 - area.getPreferredSize().height / 2;
        g2.translate(xt, yt);
        area.paint(g2);
        g2.translate(-xt, -yt);
    }

    private JTextArea getTextArea(String name, int width, int height) {
        int rows = height / this.m_rowHeight;
        CompositeKey c = new CompositeKey(new Object[]{name, width, rows});
        JTextArea area = this.lookupInCache(c);
        if (area == null) {
            area = this.createTextArea(width, height);
            this.setText(area, rows, name);
            this.storeInCache(c, area);
        }
        return area;
    }

    private void setText(JTextArea area, int rows, String name) {
        int length = name.length();
        area.setText(name);
        while (length > 10 && !this.textFitsInComponent(area, rows)) {
            area.setText(this.m_labelFormatter.format(name, length));
            --length;
        }
    }

    private boolean textFitsInComponent(JTextArea area, int rows) {
        return area.getPreferredSize().height <= rows * this.m_rowHeight;
    }

    private JTextArea createTextArea(int width, int height) {
        JTextArea area = new JTextArea();
        area.setLineWrap(true);
        area.setWrapStyleWord(false);
        area.setOpaque(false);
        area.setSize(width, height);
        if (this.m_font != null) {
            area.setFont(this.m_font);
        }
        return area;
    }

    public void setFormatter(LabelFormatter style) {
        if (this.m_labelFormatter != style) {
            this.clearCache();
        }
        this.m_labelFormatter = style;
        this.setChanged();
    }

    public List<LabelFormatter> getFormatters() {
        ArrayList<LabelFormatter> formatters = new ArrayList<LabelFormatter>();
        formatters.add(BEGINNING);
        formatters.add(CENTER);
        formatters.add(END);
        return formatters;
    }

    public LabelFormatter getFormatter() {
        return this.m_labelFormatter;
    }

    private void clearCache() {
        this.m_cache.clear();
    }

    private void storeInCache(CompositeKey c, JTextArea area) {
        if (this.m_cache.size() >= 10000) {
            this.clearCache();
        }
        this.m_cache.put(c, area);
    }

    private JTextArea lookupInCache(CompositeKey c) {
        return this.m_cache.get(c);
    }
}

