/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.operativeset.actions;

import com.jrockit.mc.common.IMCThread;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.ITrack;
import com.jrockit.mc.flightrecorder.spi.ITrackGroup;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetService;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.actions.OperativeSetAction;
import com.jrockit.mc.flightrecorder.ui.components.operativeset.model.EventToolkit;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import java.util.HashSet;
import java.util.Set;

public class AddConcurrent
extends OperativeSetAction {
    private final FlightRecording m_recording;

    public AddConcurrent(OperativeSetService oss) {
        super(oss);
        this.setText(Messages.OPERATIVE_SET_MENU_ADD_CONCURRENT);
        this.m_recording = oss.getRecording();
    }

    @Override
    protected void process() {
        long min = 0x3FFFFFFFFFFFFFFFL;
        long max = -4611686018427387904L;
        HashSet<IMCThread> threads = new HashSet<IMCThread>();
        for (IEvent e : this.getSelection()) {
            IMCThread thread = (IMCThread)e.getValue("(thread)");
            if (thread != null) {
                min = Math.min(e.getStartTimestamp(), min);
                max = Math.max(e.getEndTimestamp(), max);
                threads.add(thread);
            }
            EventToolkit.setPartOfOperativeSet(e, true);
        }
        if (min != 0x3FFFFFFFFFFFFFFFL) {
            IView view = this.m_recording.createView();
            view.setTracks(AddConcurrent.createTrackDescriptorSet(this.m_recording, threads));
            view.setRange((ITimeRange)new TimeRange(min, max));
            for (IEvent event : view) {
                EventToolkit.setPartOfOperativeSet(event, true);
            }
        }
    }

    static Set<ITrack> createTrackDescriptorSet(FlightRecording recording, Set<IMCThread> threads) {
        HashSet<ITrack> tracks = new HashSet<ITrack>();
        ITrackGroup g = recording.getRootGroup().getGroup("threadEvents");
        if (g != null) {
            for (ITrackGroup tg : g.getAllGroups()) {
                Object o = tg.getProperty("thread");
                if (!threads.contains(o)) continue;
                tracks.addAll(tg.getAllTracks());
            }
        }
        return tracks;
    }
}

