/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph.uimodel;

import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.ITrack;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.components.graph.GraphHelper;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.ColorFunction;
import com.jrockit.mc.flightrecorder.ui.components.graph.renderer.RenderInfo;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.IVisitor;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UITrack;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.Visitable;
import com.jrockit.mc.flightrecorder.ui.sampler.CompositeRangeSampler;
import com.jrockit.mc.flightrecorder.ui.sampler.ISampler;
import com.jrockit.mc.flightrecorder.ui.sampler.TrackSampler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UIGarbageCollector
implements Visitable {
    private final RenderInfo m_evenRenderInfo = new RenderInfo();
    private final RenderInfo m_oddRenderInfo = new RenderInfo();
    private final CompositeRangeSampler m_sampler;
    private final List<UITrack> m_tracks = new ArrayList<UITrack>(10);
    private final Set<String> m_paths = new HashSet<String>();

    public UIGarbageCollector(FlightRecording recording, List<ITrack> tds) {
        this.m_sampler = new CompositeRangeSampler();
        IView pauseView = recording.createView();
        pauseView.setTracks(tds);
        TrackSampler oddSampler = new TrackSampler();
        this.getOddRenderInfo().setSampler(oddSampler);
        oddSampler.setInput(pauseView);
        ColorFunction f = new ColorFunction(GraphHelper.GC_ODD_COLOR, GraphHelper.ODD_COLOR);
        this.getOddRenderInfo().setColorFunction(f);
        TrackSampler evenSampler = new TrackSampler();
        this.getEvenRenderInfo().setSampler(oddSampler);
        evenSampler.setInput(pauseView);
        this.getEvenRenderInfo().setSampler(evenSampler);
        ColorFunction f2 = new ColorFunction(GraphHelper.GC_EVEN_COLOR, GraphHelper.EVEN_COLOR);
        this.getEvenRenderInfo().setColorFunction(f2);
        this.m_sampler.add(oddSampler);
        this.m_sampler.add(evenSampler);
        this.setStructuralDirty(true);
    }

    public ISampler getSampler() {
        return this.m_sampler;
    }

    public void addTracks(List<UITrack> uiTracks) {
        for (UITrack uil : uiTracks) {
            this.addTrack(uil);
        }
    }

    public void addTrack(UITrack track) {
        this.m_tracks.add(track);
        this.m_sampler.add(track.getRenderInfo().getSampleComponent());
    }

    public RenderInfo getOddRenderInfo() {
        return this.m_oddRenderInfo;
    }

    public RenderInfo getEvenRenderInfo() {
        return this.m_evenRenderInfo;
    }

    public Collection<UITrack> getTracks() {
        return this.m_tracks;
    }

    @Override
    public boolean accept(IVisitor visitor) {
        return visitor.visit(this);
    }

    public String getName() {
        return "Garbage Collector";
    }

    public String toString() {
        return this.getName();
    }

    public boolean isGCPath(String path) {
        return this.m_paths.contains(path);
    }

    public void addPaths(String[] paths) {
        this.m_paths.addAll(Arrays.asList(paths));
    }

    public void setStructuralDirty(boolean dirty) {
        for (ISampler sampler : this.m_sampler.getChildSamplers()) {
            sampler.getSampleInfo().setStructuralDirty(dirty);
        }
        this.m_evenRenderInfo.getSampleComponent().getSampleInfo().setStructuralDirty(dirty);
        this.m_oddRenderInfo.getSampleComponent().getSampleInfo().setStructuralDirty(dirty);
    }
}

