/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.inputs;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.components.ui.settings.BrowseInput;
import com.jrockit.mc.flightrecorder.ui.components.selection.BrowseForEventAttributeWizard;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.ui.wizards.OnePageWizardDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public final class RepositoryCompatibleAttributeInput
extends BrowseInput {
    private final IServiceLocator m_serviceLocator;
    private EventTypeDescriptorRepository m_repository;
    private String m_repositoryKey;
    private final boolean m_allowFullPath;

    public RepositoryCompatibleAttributeInput(String property, String name, IServiceLocator serviceLocator, String repositoryKey, boolean allowFullPath) {
        super(property, name);
        this.m_repositoryKey = repositoryKey;
        this.m_serviceLocator = serviceLocator;
        this.m_allowFullPath = allowFullPath;
    }

    public RepositoryCompatibleAttributeInput(String property, String name, IServiceLocator serviceLocator, EventTypeDescriptorRepository edr, boolean allowFullPath) {
        super(property, name);
        this.m_serviceLocator = serviceLocator;
        this.m_repository = edr;
        this.m_allowFullPath = allowFullPath;
    }

    protected boolean browse(Shell shell) {
        String path;
        BrowseForEventAttributeWizard bfew = new BrowseForEventAttributeWizard(this.m_serviceLocator, 4, this.m_allowFullPath, this.getEventTypeRepository());
        OnePageWizardDialog dialog = new OnePageWizardDialog(shell, (IWizardPage)bfew);
        dialog.setWidthConstraint(800, Integer.MAX_VALUE);
        dialog.setHeightConstraint(600, 800);
        if (dialog.open() == 0 && (path = bfew.getPath()) != null) {
            this.setPropertyValue(path);
            return true;
        }
        return false;
    }

    private EventTypeDescriptorRepository getEventTypeRepository() {
        if (this.m_repositoryKey != null) {
            return (EventTypeDescriptorRepository)this.getSetting().getChildObject(this.m_repositoryKey, EventTypeDescriptorRepository.class);
        }
        return this.m_repository;
    }

    protected String getTextualRepresentation() {
        return this.getPropertyValue();
    }

    protected boolean hasValidData() {
        return this.getPropertyValue().trim().length() != 0;
    }
}

