/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr;

import com.jrockit.mc.rjmx.services.flr.EventTypeID;

public final class EventOptionID
implements Comparable<EventOptionID> {
    private final EventTypeID eventTypeID;
    private final String optionURI;
    private final String optionPath;
    private final String optionKey;

    public EventOptionID(EventTypeID eventTypeID, String optionKey) {
        this.eventTypeID = eventTypeID;
        this.optionURI = String.valueOf(eventTypeID.getEventURI()) + '/' + optionKey;
        this.optionPath = this.optionURI.substring(eventTypeID.getProducerURI().length());
        this.optionKey = optionKey;
    }

    public EventTypeID getEventTypeID() {
        return this.eventTypeID;
    }

    public String getEventURI() {
        return this.eventTypeID.getEventURI();
    }

    public String getOptionURI() {
        return this.optionURI;
    }

    public String getOptionPath() {
        return this.optionPath;
    }

    public String getOptionKey() {
        return this.optionKey;
    }

    public boolean equals(Object other) {
        if (other instanceof EventOptionID) {
            EventOptionID otherID = (EventOptionID)other;
            return this.optionURI.equals(otherID.optionURI) && this.optionPath.equals(otherID.optionPath);
        }
        return false;
    }

    public int hashCode() {
        return this.optionURI.hashCode();
    }

    public String toString() {
        return this.optionURI;
    }

    @Override
    public int compareTo(EventOptionID other) {
        return this.optionURI.compareTo(other.optionURI);
    }
}

