/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.core.idesupport.IDESupportToolkit;
import com.jrockit.mc.core.idesupport.IIDESupport;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ImageConstants;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplateRepository;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.TemplateRepositoryFactory;
import com.jrockit.mc.rjmx.IServerHandle;
import com.jrockit.mc.rjmx.services.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.ui.MCAbstractUIPlugin;
import com.jrockit.mc.ui.idesupport.IDESupportUIToolkit;
import com.jrockit.mc.ui.misc.DialogToolkit;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageRegistry;
import org.osgi.framework.BundleContext;

public final class ControlPanel
extends MCAbstractUIPlugin {
    private static final String LAST_PATH = "last.jfr.path";
    private static final String PLUGIN_ID = "com.jrockit.mc.flightrecorder.controlpanel.ui";
    private static final String LICENSE_URL = "http://www.oracle.com/technetwork/java/javase/terms/products/index.html";
    private static final String DEFAULT_FILENAME = "flight_recording";
    private static final String FLIGHT_RECORDING_FILE_EXTENSION = "jfr";
    private static ControlPanel s_plugin;
    private RecordingTemplateRepository m_repository;

    public ControlPanel() {
        super(PLUGIN_ID);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        s_plugin = this;
        this.m_repository = TemplateRepositoryFactory.create();
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerFromImageConstantClass(registry, ImageConstants.class);
    }

    public void stop(BundleContext context) throws Exception {
        s_plugin = null;
        super.stop(context);
    }

    public static ControlPanel getDefault() {
        return s_plugin;
    }

    public RecordingTemplateRepository getRecordingTemplateRepository() {
        return this.m_repository;
    }

    public static boolean askUserForEnable(IFlightRecorderService flrService, String question) throws FlightRecorderException {
        if (DialogToolkit.openQuestionWithLinkOnUiThread((String)Messages.COMMERCIAL_FEATURES_QUESTION_TITLE, (String)(String.valueOf(question) + "\n\n" + Messages.COMMERCIAL_FEATURES_QUESTION_TIP + "\n\n" + Messages.COMMERCIAL_FEATURES_QUESTION_LICENSE), (String)Messages.COMMERCIAL_FEATURES_QUESTION_LINKTEXT, (String)LICENSE_URL)) {
            flrService.enable();
            return true;
        }
        return false;
    }

    public static MCFile getDefaultRecordingFile(IServerHandle server) {
        return ControlPanel.getDefaultRecordingFile(server.getServerDescriptor().getDisplayName());
    }

    public static MCFile getDefaultRecordingFile(String suffixPart) {
        suffixPart = (suffixPart = suffixPart.replaceAll("[^A-Za-z0-9]", "")).length() > 0 ? "_" + suffixPart : suffixPart;
        IPath lastPath = Path.fromOSString((String)ControlPanel.getDefault().getPreferenceStore().getString(LAST_PATH));
        IPath lastFolder = lastPath.removeLastSegments(1);
        MCFile f = ControlPanel.getDefaultRecordingFile(lastFolder, suffixPart);
        int i = 1;
        while (IDESupportToolkit.validateFileResourcePath((String)f.getPath()) == IIDESupport.FILE_EXISTS_STATUS && i < 100000) {
            f = ControlPanel.getDefaultRecordingFile(lastFolder, String.valueOf(suffixPart) + "_" + i++);
        }
        return f;
    }

    private static MCFile getDefaultRecordingFile(IPath folder, String suffixPart) {
        String filename = DEFAULT_FILENAME + suffixPart + "." + FLIGHT_RECORDING_FILE_EXTENSION;
        return IDESupportToolkit.createDefaultFileResource((String)folder.append(filename).toOSString());
    }

    public static MCFile openRecordingFileBrowser(MCFile currentFile) {
        MCFile selected = CorePlugin.getDefault().getIDESupport().browseForSaveAsFile(Messages.RECORDING_FILE_BROWSER_TITLE, currentFile.getPath(), FLIGHT_RECORDING_FILE_EXTENSION, Messages.RECORDING_FILE_BROWSER_DESCRIPTION);
        if (selected != null) {
            ControlPanel.getDefault().getPreferenceStore().putValue(LAST_PATH, selected.getPath());
        }
        return selected;
    }

    public static File openSaveAsFileBrowser(File srcFile) {
        return IDESupportUIToolkit.browseForSaveAsFile((String)Messages.SAVE_AS_TITLE, (File)srcFile, (String)FLIGHT_RECORDING_FILE_EXTENSION, (String)Messages.SAVE_AS_JFR_DESCRIPTION);
    }

    public static String getRecordingFileValidationMessage(IStatus pathValidation) {
        if (pathValidation == IIDESupport.FILE_EXISTS_STATUS) {
            return Messages.RECORDING_FILE_EXISTS;
        }
        if (!pathValidation.isOK()) {
            return pathValidation.getMessage();
        }
        return null;
    }
}

