/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.linux.arm;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.cdbg.CFrame;
import sun.jvm.hotspot.debugger.cdbg.ClosestSymbol;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCFrame;
import sun.jvm.hotspot.debugger.linux.LinuxDebugger;
import sun.jvm.hotspot.debugger.linux.arm.LinuxARMThreadContext;

public final class LinuxARMCFrame
extends BasicCFrame {
    private boolean safeForSender;
    private Address pc;
    private Address fp;
    private LinuxDebugger dbg;

    private LinuxARMCFrame(LinuxDebugger dbg, Address fp, Address pc) {
        super(dbg.getCDebugger());
        this.fp = fp;
        this.pc = pc;
        this.dbg = dbg;
    }

    private LinuxARMCFrame(LinuxDebugger dbg, Address fp, Address pc, LinuxARMCFrame parent) {
        this(dbg, fp, pc);
        this.safeForSender = this.checkFrameBounds(fp, parent.fp) && fp != null && !fp.equals(parent.fp);
    }

    private LinuxARMCFrame(LinuxDebugger dbg, Address fp, Address pc, Address sp) {
        this(dbg, fp, pc);
        this.safeForSender = this.checkFrameBounds(fp, sp);
    }

    public static LinuxARMCFrame getTopFrameFor(LinuxDebugger dbg, LinuxARMThreadContext context) {
        Address fp = context.getRegisterAsAddress(context.getFPRegisterIndex());
        Address pc = context.getRegisterAsAddress(context.getPCRegisterIndex());
        if (pc == null) {
            return null;
        }
        Address sp = context.getRegisterAsAddress(context.getSPRegisterIndex());
        if (sp == null) {
            return null;
        }
        if (!dbg.getMachineDescription().isLP64()) {
            fp = sp;
        }
        return new LinuxARMCFrame(dbg, fp, pc, sp);
    }

    private boolean checkFrameBounds(Address top, Address bottom) {
        long MAX_FRAME_SIZE = 4096L * this.dbg.getMachineDescription().getAddressSize();
        if (top == null || bottom == null) {
            return false;
        }
        if (top.lessThan(bottom)) {
            return false;
        }
        return !bottom.addOffsetTo(MAX_FRAME_SIZE).lessThan(top);
    }

    @Override
    public ClosestSymbol closestSymbolToPC() {
        return this.dbg.lookup(this.dbg.getAddressValue(this.pc()));
    }

    @Override
    public Address pc() {
        return this.pc;
    }

    @Override
    public Address localVariableBase() {
        return this.fp;
    }

    @Override
    public CFrame sender(ThreadProxy thread) {
        long STACK_ALIGNMENT;
        if (!this.safeForSender) {
            return null;
        }
        long l = STACK_ALIGNMENT = this.dbg.getMachineDescription().isLP64() ? 16L : 4L;
        if (this.dbg.getAddressValue(this.fp) % STACK_ALIGNMENT != 0L) {
            return null;
        }
        if (this.fp == null) {
            return null;
        }
        long ADDRESS_SIZE = this.dbg.getMachineDescription().getAddressSize();
        try {
            Address nextFP = this.fp.getAddressAt(0L * ADDRESS_SIZE);
            Address nextPC = this.fp.getAddressAt(1L * ADDRESS_SIZE);
            if (nextPC == null) {
                return null;
            }
            return new LinuxARMCFrame(this.dbg, nextFP, nextPC, this);
        }
        catch (AddressException e) {
            return null;
        }
    }
}

