/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.application.p2;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.rcp.application.ApplicationPlugin;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;

public final class UpdateSiteURLToolkit {
    private static final String KEY_UPDATE_PROPERTIES_PATH = "com.oracle.jmc.updatesites.properties";
    private static final String KEY_IS_ON_ORACLE_NETWORK = "com.oracle.jmc.updatesites.isonoraclenetwork";
    private static final Object SITES_LOCK = new Object();
    private static List<String> SITES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getUpdateSites() {
        Object object = SITES_LOCK;
        synchronized (object) {
            if (SITES == null) {
                ArrayList<String> updateSites = new ArrayList<String>();
                Properties props = UpdateSiteURLToolkit.readOverrideProperties();
                if (props == null) {
                    props = UpdateSiteURLToolkit.readDefaultProperties();
                }
                if (props != null) {
                    String site;
                    int i = 0;
                    do {
                        if ((site = props.getProperty("updatesite." + i++)) == null) continue;
                        updateSites.add(MessageFormat.format(site, ApplicationPlugin.FULL_VERSION));
                    } while (site != null);
                }
                SITES = updateSites;
            }
            return SITES;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Properties readDefaultProperties() {
        Properties properties;
        InputStream is = null;
        try {
            is = UpdateSiteURLToolkit.class.getClassLoader().getResourceAsStream("updatesites.properties");
            Properties props = new Properties();
            props.load(is);
            properties = props;
        }
        catch (IOException e) {
            try {
                ApplicationPlugin.getLogger().log(Level.WARNING, "Could not load default update sites", e);
            }
            catch (Throwable throwable) {
                IOToolkit.closeSilently(is);
                throw throwable;
            }
            IOToolkit.closeSilently((Closeable)is);
            return null;
        }
        IOToolkit.closeSilently((Closeable)is);
        return properties;
    }

    private static Properties readOverrideProperties() {
        File propertiesFile;
        String propertiesPath = System.getProperty(KEY_UPDATE_PROPERTIES_PATH);
        if (propertiesPath != null && UpdateSiteURLToolkit.isOnOracleNetwork() && (propertiesFile = new File(propertiesPath)).isFile() && propertiesFile.canRead()) {
            Properties properties;
            FileInputStream is = null;
            try {
                is = new FileInputStream(propertiesFile);
                Properties props = new Properties();
                props.load(is);
                properties = props;
            }
            catch (IOException e) {
                try {
                    ApplicationPlugin.getLogger().log(Level.WARNING, "Could not load override update sites", e);
                }
                catch (Throwable throwable) {
                    IOToolkit.closeSilently(is);
                    throw throwable;
                }
                IOToolkit.closeSilently((Closeable)is);
            }
            IOToolkit.closeSilently((Closeable)is);
            return properties;
        }
        return null;
    }

    private UpdateSiteURLToolkit() {
        throw new AssertionError((Object)"Not to be instantiated!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isOnOracleNetwork() {
        if (System.getProperty(KEY_IS_ON_ORACLE_NETWORK) != null) {
            return Boolean.getBoolean(KEY_IS_ON_ORACLE_NETWORK);
        }
        try {
            for (InetAddress address : UpdateSiteURLToolkit.getAvailableAddresses()) {
                String hostName = address.getHostName();
                if (hostName == null || !hostName.endsWith(".oracle.com") && !hostName.endsWith(".oraclecorp.com") && !hostName.endsWith(".bea.com")) continue;
                return true;
            }
        }
        catch (SocketException e) {
            ApplicationPlugin.getLogger().log(Level.INFO, "Could not determine local addresses", e);
        }
        ApplicationPlugin.getLogger().info("Internal update site override feature disabled");
        return false;
    }

    private static List<InetAddress> getAvailableAddresses() throws SocketException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
        while (nics.hasMoreElements()) {
            NetworkInterface nic = nics.nextElement();
            UpdateSiteURLToolkit.add(nic.getInetAddresses(), addresses);
        }
        return addresses;
    }

    private static void add(Enumeration<InetAddress> inetAddresses, List<InetAddress> addresses) {
        while (inetAddresses.hasMoreElements()) {
            addresses.add(inetAddresses.nextElement());
        }
    }
}

