/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.operations;

import com.jrockit.mc.common.util.TypeHandling;
import com.jrockit.mc.rjmx.services.IAttribute;
import com.jrockit.mc.rjmx.services.IAttributeInfo;
import com.jrockit.mc.rjmx.services.IOperation;
import com.jrockit.mc.rjmx.services.IReadOnlyAttribute;
import com.jrockit.mc.rjmx.services.IllegalOperandException;
import com.jrockit.mc.rjmx.ui.attributes.AttributeTreeBuilder;
import com.jrockit.mc.rjmx.ui.attributes.ChangeValueAction;
import com.jrockit.mc.rjmx.ui.attributes.ValueColumnLabelProvider;
import com.jrockit.mc.rjmx.ui.celleditors.AttributeEditingSupport;
import com.jrockit.mc.rjmx.ui.column.Column;
import com.jrockit.mc.rjmx.ui.column.TreeColumnComposite;
import com.jrockit.mc.rjmx.ui.internal.InsertArrayElementMenuAction;
import com.jrockit.mc.rjmx.ui.internal.RemoveArrayElementMenuAction;
import com.jrockit.mc.rjmx.ui.operations.Messages;
import com.jrockit.mc.rjmx.ui.operations.OperationsLabelProvider;
import com.jrockit.mc.rjmx.util.internal.DefaultAttribute;
import com.jrockit.mc.ui.handlers.InFocusHandlerActivator;
import com.jrockit.mc.ui.handlers.MCSelectionProviderAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class InvocatorBuilderForm {
    private List<IReadOnlyAttribute> attributes;
    private final TableViewer operationsPart;
    private final InvocatorUpdateListener invocatorUpdatedListener;
    private Set<IAttributeInfo> invalidValues = Collections.emptySet();

    public InvocatorBuilderForm(SashForm parent, FormToolkit formToolkit, boolean showOperationReturnType, boolean showDescriptionBeforeValue, IDialogSettings settings, InvocatorUpdateListener invocatorUpdatedListener) {
        this.invocatorUpdatedListener = invocatorUpdatedListener;
        parent.setBackground(formToolkit.getColors().getBackground());
        this.operationsPart = InvocatorBuilderForm.createIOperationList((Composite)parent, showOperationReturnType);
        this.operationsPart.getTable().setHeaderVisible(true);
        TreeColumnComposite parametersPart = AttributeTreeBuilder.build((Composite)parent, DialogSettings.getOrCreateSection((IDialogSettings)settings, (String)"attributes"));
        final TreeViewer parametersTable = parametersPart.getViewer();
        Column valueColumn = new Column(com.jrockit.mc.rjmx.ui.attributes.Messages.AttributeInspector_VALUE_COLUMN_HEADER, null, "value", 0, new ValueLabelProvider(), AttributeTreeBuilder.VALUE_CELL_ACCESSOR, new EditingSupport((ColumnViewer)parametersTable));
        if (showDescriptionBeforeValue) {
            parametersPart.addColumns(AttributeTreeBuilder.NAME, AttributeTreeBuilder.DESCRIPTION, valueColumn, AttributeTreeBuilder.TYPE);
        } else {
            parametersPart.addColumns(AttributeTreeBuilder.NAME, valueColumn, AttributeTreeBuilder.TYPE, AttributeTreeBuilder.DESCRIPTION);
        }
        parametersPart.getMenuManager().add((IAction)new ChangeValueAction(parametersPart, valueColumn));
        parametersPart.getMenuManager().add((IContributionItem)InsertArrayElementMenuAction.createInsertArrayElementMenuActionContribution(parametersPart, valueColumn, false));
        parametersPart.getMenuManager().add((IContributionItem)InsertArrayElementMenuAction.createInsertArrayElementMenuActionContribution(parametersPart, valueColumn, true));
        parametersPart.getMenuManager().add((IContributionItem)RemoveArrayElementMenuAction.createRemoveArrayElementMenuActionContribution(parametersPart, valueColumn));
        parametersPart.setLayoutData(new GridData(4, 4, true, true));
        parent.setWeights(new int[]{1, 2});
        this.operationsPart.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IOperation operation = InvocatorBuilderForm.this.getSelectedOperation();
                InvocatorBuilderForm.this.attributes = new ArrayList();
                if (operation != null) {
                    for (IAttributeInfo valueInfo : operation.getSignature()) {
                        InvocatorBuilderForm.this.attributes.add(new ArgumentAttribute(operation, valueInfo));
                    }
                }
                InvocatorBuilderForm.this.evaluateOperation(operation);
                parametersTable.setInput((Object)InvocatorBuilderForm.this.attributes.toArray());
            }
        });
        MCSelectionProviderAction delHandler = new MCSelectionProviderAction("org.eclipse.ui.edit.delete", (ISelectionProvider)parametersTable){

            public void run() {
                for (Object o : this.getStructuredSelection().toList()) {
                    if (!(o instanceof IAttribute)) continue;
                    ((IAttribute)o).setValue(null);
                }
                InvocatorBuilderForm.this.evaluateOperation(InvocatorBuilderForm.this.getSelectedOperation());
                parametersTable.refresh();
            }
        };
        InFocusHandlerActivator.install((Control)parametersTable.getControl(), (IAction)delHandler);
        parametersPart.getMenuManager().add((IAction)delHandler);
    }

    private static TableViewer createIOperationList(Composite parent, boolean showReturns) {
        TableViewer tableViewer = new TableViewer(new Composite(parent, 0), 67588);
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof IOperation) {
                    return ((IOperation)element).getImpact().ordinal();
                }
                return 0;
            }
        });
        TableColumn tvc = new TableColumn(tableViewer.getTable(), 0);
        tvc.setText(Messages.OperationsSectionPart_TITLE);
        TableColumnLayout l = new TableColumnLayout();
        tableViewer.getTable().getParent().setLayout((Layout)l);
        l.setColumnData((Widget)tvc, (ColumnLayoutData)new ColumnWeightData(1));
        tableViewer.setLabelProvider((IBaseLabelProvider)new OperationsLabelProvider(showReturns));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
        return tableViewer;
    }

    public void setOperations(Collection<? extends IOperation> input) {
        this.operationsPart.setInput(input);
    }

    private void evaluateOperation(IOperation operation) {
        try {
            Callable invocator = operation == null ? null : operation.getInvocator(this.getValues());
            this.invocatorUpdatedListener.onInvocatorUpdated(operation, invocator);
            this.invalidValues = Collections.emptySet();
        }
        catch (IllegalOperandException e) {
            this.invalidValues = e.getInvalidValues();
            this.invocatorUpdatedListener.onInvocatorUpdated(operation, null);
        }
    }

    private Object[] getValues() {
        Object[] values = new Object[this.attributes.size()];
        int i = 0;
        while (i < values.length) {
            values[i] = this.attributes.get(i).getValue();
            ++i;
        }
        return values;
    }

    public IOperation getSelectedOperation() {
        IStructuredSelection str;
        ISelection selection = this.operationsPart.getSelection();
        if (!selection.isEmpty() && (str = (IStructuredSelection)selection).getFirstElement() instanceof IOperation) {
            return (IOperation)str.getFirstElement();
        }
        return null;
    }

    private class ArgumentAttribute
    extends DefaultAttribute {
        private final IOperation operation;

        public ArgumentAttribute(IOperation operation, IAttributeInfo info) {
            super(info);
            this.operation = operation;
        }

        public void setValue(Object value) {
            super.setValue(value);
            InvocatorBuilderForm.this.evaluateOperation(this.operation);
        }
    }

    private class EditingSupport
    extends AttributeEditingSupport<IAttribute> {
        public EditingSupport(ColumnViewer viewer) {
            super(viewer, IAttribute.class);
        }

        @Override
        protected void setValue(Object element, Object value) {
            super.setValue(element, value);
            InvocatorBuilderForm.this.evaluateOperation(InvocatorBuilderForm.this.getSelectedOperation());
            this.getViewer().refresh(element);
        }
    }

    public static interface InvocatorUpdateListener {
        public void onInvocatorUpdated(IOperation var1, Callable<?> var2);
    }

    private class ValueLabelProvider
    extends ValueColumnLabelProvider {
        private ValueLabelProvider() {
        }

        @Override
        protected Color getForegroundTyped(IReadOnlyAttribute value) {
            if (InvocatorBuilderForm.this.invalidValues.contains(value.getInfo())) {
                return JFaceResources.getColorRegistry().get("ERROR_COLOR");
            }
            return super.getForegroundTyped(value);
        }

        @Override
        protected String getToolTipTextTyped(IReadOnlyAttribute attribute) {
            if (InvocatorBuilderForm.this.invalidValues.contains(attribute.getInfo())) {
                return NLS.bind((String)Messages.InvocatorBuilderForm_ILLEGAL_OPERAND, (Object)TypeHandling.simplifyType((String)attribute.getInfo().getType()));
            }
            return super.getToolTipTextTyped(attribute);
        }

        @Override
        protected Color getBackgroundTyped(IReadOnlyAttribute element) {
            return Display.getDefault().getSystemColor(29);
        }
    }
}

