/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.awt;

import com.sun.applet2.Applet2Context;
import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.config.OSType;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.uitoolkit.Applet2Adapter;
import com.sun.deploy.uitoolkit.UIToolkit;
import com.sun.deploy.uitoolkit.WindowFactory;
import com.sun.deploy.uitoolkit.impl.awt.AWTAppContext;
import com.sun.deploy.uitoolkit.impl.awt.AWTWindowFactory;
import com.sun.deploy.uitoolkit.impl.awt.ui.DownloadWindow;
import com.sun.deploy.uitoolkit.impl.awt.ui.UIFactoryImpl;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import com.sun.deploy.util.ReflectionUtil;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.SwingUtilities;

public class UIToolkitImpl
extends UIToolkit {
    private final UIFactory uiFactory = new UIFactoryImpl();
    private AppContext appContext;

    public AppContext getAppContext() {
        return AWTAppContext.getInstance();
    }

    public AppContext createAppContext() {
        return AWTAppContext.createAppContext();
    }

    public void init() throws Exception {
    }

    public void dispose() throws Exception {
    }

    public UIFactory getUIFactory() {
        return this.uiFactory;
    }

    public boolean isDisposed(Object object) {
        Window window = (Window)object;
        return !window.isDisplayable();
    }

    public WindowFactory getWindowFactory() {
        return new AWTWindowFactory();
    }

    public Preloader getDefaultPreloader() {
        Trace.println("AWT UIToolkit get Downloadwindow as preloader ", TraceLevel.UI);
        return new DownloadWindow();
    }

    public boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public void setContextClassLoader(final ClassLoader classLoader) {
        if (classLoader == null) {
            return;
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        Thread.currentThread().setContextClassLoader(classLoader);
                    }
                    catch (Throwable throwable) {
                        Trace.ignored(throwable);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Trace.ignoredException(interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Trace.ignoredException(invocationTargetException);
        }
    }

    private void forceGTKInitialization(Toolkit toolkit) {
        if (OSType.isUnix()) {
            try {
                Method method = ReflectionUtil.getMethod(toolkit, "loadGTK", null, false);
                if (method != null) {
                    method.invoke((Object)toolkit, (Object[])null);
                }
            }
            catch (Throwable throwable) {
                Trace.ignored(throwable);
            }
        }
    }

    public void warmup() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.forceGTKInitialization(toolkit);
        this.getAppContext().invokeLater(new Runnable(){

            public void run() {
            }
        });
    }

    public Applet2Adapter getApplet2Adapter(Applet2Context applet2Context) {
        try {
            return (Applet2Adapter)ReflectionUtil.createInstance("com.sun.deploy.uitoolkit.impl.awt.AWTAppletAdapter", new Class[]{Applet2Context.class}, new Object[]{applet2Context}, null);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public SecurityManager getSecurityManager() {
        SecurityManager securityManager = null;
        try {
            securityManager = (SecurityManager)ReflectionUtil.createInstance("sun.plugin2.applet.AWTAppletSecurityManager", null);
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
        return securityManager;
    }

    public UIToolkit changeMode(int n) {
        Object var2_2 = null;
        UIToolkit uIToolkit = null;
        try {
            if (n == 1) {
                uIToolkit = (UIToolkit)ReflectionUtil.createInstance("com.sun.deploy.uitoolkit.impl.awt.AWTPluginUIToolkit", new Class[]{UIToolkitImpl.class}, new Object[]{this}, null);
            } else if (n == 0) {
                uIToolkit = (UIToolkit)ReflectionUtil.createInstance("com.sun.deploy.uitoolkit.impl.awt.UIToolkitImpl", null);
                ((UIToolkitImpl)uIToolkit).appContext = this.appContext;
            }
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
        }
        if (uIToolkit != null) {
            return uIToolkit;
        }
        Trace.println("toolkit didn't switch to new mode successfully", TraceLevel.UI);
        return this;
    }
}

