/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.fields;

import com.jrockit.mc.common.IMCAggregatedFrame;
import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.common.IMCThread;
import com.jrockit.mc.common.IMCType;
import com.jrockit.mc.ui.UIPlugin;
import java.lang.reflect.Modifier;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class CommonLabelProvider
extends LabelProvider {
    public Image getImage(Object element) {
        return CommonLabelProvider.getStandardImage(element);
    }

    public static Image getStandardImage(Object element) {
        IMCAggregatedFrame mf;
        IMCAggregatedFrame.AggregationType t;
        if (element instanceof IMCAggregatedFrame && (t = (mf = (IMCAggregatedFrame)element).getAggregationType()) != null) {
            return CommonLabelProvider.getAggregatedFrameImage(t);
        }
        if (element instanceof IMCFrame) {
            IMCFrame f = (IMCFrame)element;
            if (IMCFrame.Type.JIT_COMPILED == f.getType() || IMCFrame.Type.INLINED == f.getType()) {
                return UIPlugin.getDefault().getImage("optimized-method-16.png");
            }
            if (IMCFrame.Type.INTERPRETED == f.getType()) {
                return UIPlugin.getDefault().getImage("non-optimized-method-16.png");
            }
            return UIPlugin.getDefault().getImage("stckframe_obj.gif");
        }
        if (element instanceof IMCMethod) {
            IMCMethod m = (IMCMethod)element;
            Integer modifier = m.getModifier();
            if (modifier != null) {
                CommonLabelProvider.getModifierImage(modifier);
            }
            return UIPlugin.getDefault().getImage("methdef_obj.gif");
        }
        if (element instanceof IMCType) {
            return UIPlugin.getDefault().getImage("class_obj.gif");
        }
        if (element instanceof IMCThread) {
            return CommonLabelProvider.getThreadImage((IMCThread)element);
        }
        return null;
    }

    private static Image getAggregatedFrameImage(IMCAggregatedFrame.AggregationType type) {
        if (type == IMCAggregatedFrame.AggregationType.PREDECESSORS) {
            return UIPlugin.getDefault().getImage("callee.png");
        }
        if (type == IMCAggregatedFrame.AggregationType.SUCCESSORS) {
            return UIPlugin.getDefault().getImage("caller.png");
        }
        return UIPlugin.getDefault().getImage("stckframe_obj.gif");
    }

    private static Image getThreadImage(IMCThread thread) {
        if (thread.isDeadlocked() != null && thread.isDeadlocked().booleanValue()) {
            return UIPlugin.getDefault().getImage("live-thread-deadlocked-16.PNG");
        }
        if ("BLOCKED".equalsIgnoreCase(thread.getThreadState())) {
            return UIPlugin.getDefault().getImage("live-thread-locked-16.png");
        }
        if ("WAITING".equalsIgnoreCase(thread.getThreadState())) {
            return UIPlugin.getDefault().getImage("live-thread-waiting-16.png");
        }
        if ("TIMED_WAITING".equalsIgnoreCase(thread.getThreadState())) {
            return UIPlugin.getDefault().getImage("live-thread-timewaiting-16.png");
        }
        if ("RUNNABLE".equalsIgnoreCase(thread.getThreadState())) {
            return UIPlugin.getDefault().getImage("thread_obj.gif");
        }
        if ("SUSPENDED".equalsIgnoreCase(thread.getThreadState())) {
            return UIPlugin.getDefault().getImage("threads_obj.gif");
        }
        if ("TERMINATED".equalsIgnoreCase(thread.getThreadState())) {
            return UIPlugin.getDefault().getImage("threadt_obj.gif");
        }
        return UIPlugin.getDefault().getImage("thread_obj.gif");
    }

    private static Image getModifierImage(Integer modifier) {
        if (Modifier.isPublic(modifier)) {
            return UIPlugin.getDefault().getImage("methpub_obj.gif");
        }
        if (Modifier.isPrivate(modifier)) {
            return UIPlugin.getDefault().getImage("methpri_obj.gif");
        }
        if (Modifier.isProtected(modifier)) {
            return UIPlugin.getDefault().getImage("methpro_obj.gif");
        }
        return UIPlugin.getDefault().getImage("non-optimized-method-16.png");
    }
}

