/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.fields;

import com.jrockit.mc.ui.fields.CommonLabelProvider;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.Row;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class FieldLabelProvider
implements ITableLabelProvider,
ILabelProvider,
IFontProvider {
    protected final Field[] m_fields;
    protected final ILabelProvider m_imageProvider;
    protected final IFontProvider m_fontProvider;

    public FieldLabelProvider(Field[] fields) {
        this(fields, (IBaseLabelProvider)new CommonLabelProvider());
    }

    public FieldLabelProvider(Field[] fields, IBaseLabelProvider provider) {
        this.m_fields = fields;
        this.m_imageProvider = provider instanceof ILabelProvider ? (ILabelProvider)provider : null;
        this.m_fontProvider = provider instanceof IFontProvider ? (IFontProvider)provider : null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (this.m_imageProvider != null && columnIndex == 0 && element instanceof Row) {
            return this.m_imageProvider.getImage(((Row)element).getElement());
        }
        return null;
    }

    private Font getColumnFont(Object element, int columnIndex) {
        if (this.m_fontProvider != null && element instanceof Row) {
            return ((IFontProvider)this.m_imageProvider).getFont(((Row)element).getElement());
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof Row) {
            int i = 0;
            Field[] fieldArray = this.m_fields;
            int n = this.m_fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field m_field = fieldArray[n2];
                if (m_field.isVisible()) {
                    if (i == columnIndex) {
                        return m_field.formatObject(((Row)element).getColumn(m_field.INDEX));
                    }
                    ++i;
                }
                ++n2;
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.m_imageProvider != null) {
            this.m_imageProvider.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public String getText(Object element) {
        return this.m_fields[0].formatObject(((Row)element).getColumn(this.m_fields[0].INDEX));
    }

    public Font getFont(Object element) {
        return this.getColumnFont(element, 0);
    }

    public Field[] getFields() {
        return this.m_fields;
    }
}

