/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.CouldNotLoadRecordingException;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.FlightRecordingLoader;
import com.jrockit.mc.flightrecorder.NotEnoughMemoryException;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Chunk;
import com.jrockit.mc.flightrecorder.internal.parser.binary.RepositoryBuilder;
import com.jrockit.mc.flightrecorder.internal.parser.binary.factories.GlobalObjectPool;
import com.jrockit.mc.flightrecorder.spi.IRepository;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Logger;

public class LoaderContext {
    private static final Logger LOGGER = Logger.getLogger(LoaderContext.class.getName());
    private static final double MIN_AVAILABLE_MEMORY = 0.1;
    private final GlobalObjectPool globalObjects;
    private final FlightRecordingLoader.ILoadingMonitor monitor;
    private final Queue<Chunk> chunks = new LinkedList<Chunk>();
    private final Queue<byte[]> dataBuffers = new LinkedList<byte[]>();
    private Throwable error;
    private Integer chunkCount;

    public LoaderContext(FlightRecordingLoader.ILoadingMonitor monitor, boolean showHiddenMethods, int bufferCount, int bufferSize) {
        this.monitor = monitor;
        this.globalObjects = new GlobalObjectPool(showHiddenMethods);
        int i = 0;
        while (i < bufferCount) {
            this.dataBuffers.add(new byte[bufferSize]);
            ++i;
        }
    }

    public GlobalObjectPool getGlobalObjects() {
        return this.globalObjects;
    }

    public FlightRecording load() throws CouldNotLoadRecordingException {
        Chunk chunk;
        RepositoryBuilder repositoryBuilder = new RepositoryBuilder();
        int readChunks = 0;
        while ((chunk = this.getLoadedChunk(readChunks)) != null) {
            ++readChunks;
            repositoryBuilder.addChunk(chunk);
            try {
                this.monitor.doWork(1);
            }
            catch (RuntimeException e) {
                this.setFailed(e);
                throw e;
            }
        }
        this.dataBuffers.clear();
        IRepository repo = repositoryBuilder.buildRepository(this.globalObjects.getAllProducers());
        LOGGER.fine("Loaded FlightRecording " + repo.getEventTypes().size() + " event types and " + this.globalObjects.getAllProducers().size() + " producers");
        return new FlightRecording(repo);
    }

    public synchronized void returnBuffer(byte[] reusableBuffer) {
        this.dataBuffers.add(reusableBuffer);
        this.notifyAll();
    }

    public synchronized void chunkLoaded(Chunk chunk) {
        this.chunks.add(chunk);
        this.notifyAll();
    }

    public synchronized void allChunksLoaded(int readChunks) {
        this.chunkCount = readChunks;
        this.notifyAll();
    }

    public synchronized void setFailed(Throwable ex) {
        if (this.error == null) {
            this.error = ex;
        }
        this.notifyAll();
    }

    public synchronized byte[] takeBuffer() {
        while (this.dataBuffers.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.checkMemoryUsage();
            if (this.error == null) continue;
            return null;
        }
        return this.dataBuffers.poll();
    }

    private synchronized Chunk getLoadedChunk(int readChunks) throws CouldNotLoadRecordingException {
        while (this.chunks.isEmpty()) {
            if (this.chunkCount != null && this.chunkCount <= readChunks) {
                return null;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.checkMemoryUsage();
            if (this.error == null) continue;
            if (this.error instanceof CouldNotLoadRecordingException) {
                throw (CouldNotLoadRecordingException)this.error;
            }
            if (this.error instanceof RuntimeException) {
                throw (RuntimeException)this.error;
            }
            if (this.error instanceof Error) {
                throw (Error)this.error;
            }
            throw new CouldNotLoadRecordingException(this.error);
        }
        return this.chunks.poll();
    }

    private void checkMemoryUsage() {
        Runtime rt = Runtime.getRuntime();
        long maxMemory = rt.maxMemory();
        long availableMemory = maxMemory - rt.totalMemory() + rt.freeMemory();
        if ((double)availableMemory < 0.1 * (double)maxMemory) {
            NotEnoughMemoryException nem = new NotEnoughMemoryException();
            this.setFailed(nem);
        }
    }
}

