/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.triggers.IValueEvaluator;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public final class ValueEvaluatorStringMatch
implements IValueEvaluator {
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
    private static final String XML_ELEMENT_MATCHSTRING = "maxvalue";
    private String m_matchString;

    public ValueEvaluatorStringMatch() {
    }

    public ValueEvaluatorStringMatch(String matchString) {
        this.m_matchString = matchString;
    }

    @Override
    public boolean triggerOn(Object val) {
        if (val != null && this.m_matchString != null) {
            boolean result = this.matcher(val.toString(), this.m_matchString);
            LOGGER.info("ValueEvaluatorStringMatch:" + val.toString() + " matches " + this.m_matchString + " = " + result);
            return result;
        }
        return false;
    }

    private boolean matcher(String s, String matchString) {
        if (s.length() == 0) {
            return matchString.length() == 0 || matchString.equals("*");
        }
        if (matchString.length() == 0) {
            return false;
        }
        if (matchString.charAt(0) == '*') {
            int n = 0;
            while (n <= s.length()) {
                if (this.matcher(s.substring(n), matchString.substring(1))) {
                    return true;
                }
                ++n;
            }
        } else {
            if (matchString.charAt(0) == '?') {
                return this.matcher(s.substring(1), matchString.substring(1));
            }
            if (matchString.charAt(0) == s.charAt(0)) {
                return this.matcher(s.substring(1), matchString.substring(1));
            }
        }
        return false;
    }

    public String toString() {
        return "value matches " + this.m_matchString;
    }

    public String getMatchString() {
        return this.m_matchString;
    }

    public void setMatchString(String matchString) {
        this.m_matchString = matchString;
    }

    @Override
    public void initializeEvaluatorFromXml(Element node) {
        this.setMatchString(XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_MATCHSTRING, (String)"*"));
    }

    @Override
    public void exportEvaluatorToXml(Element node) {
        XmlToolkit.setSetting((Element)node, (String)XML_ELEMENT_MATCHSTRING, (String)this.getMatchString());
    }

    @Override
    public String getOperatorString() {
        return " matches";
    }

    @Override
    public String getEvaluationConditionString() {
        return "matches " + this.m_matchString;
    }
}

