/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.association.utility;

import com.sun.deploy.association.Association;
import com.sun.deploy.association.AssociationService;
import com.sun.deploy.association.RegisterFailedException;
import com.sun.deploy.association.utility.AppAssociationWriter;
import com.sun.deploy.association.utility.MacOSXBundleUtil;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.File;
import java.util.List;

public class MacOSXAppAssociationWriter
implements AppAssociationWriter {
    private static final String BUNDLE_PATH_KEY = "macosx.bundlePath";
    private final LocalApplicationProperties lap;

    public MacOSXAppAssociationWriter(LocalApplicationProperties localApplicationProperties) {
        this.lap = localApplicationProperties;
    }

    public void checkAssociationValidForRegistration(Association association) throws IllegalArgumentException {
    }

    public void checkAssociationValidForUnregistration(Association association) throws IllegalArgumentException {
    }

    public boolean isAssociationExist(Association association, int n) {
        AssociationService associationService = new AssociationService(this.lap);
        List list = associationService.getAssociations();
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            Association association2 = (Association)list.get(i);
            if (!MacOSXBundleUtil.compareAssociations(association, association2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void registerAssociation(Association association, int n) throws RegisterFailedException {
        this.registerApplication();
    }

    public void unregisterAssociation(Association association, int n) throws RegisterFailedException {
    }

    private static File getBundleFile(LocalApplicationProperties localApplicationProperties) {
        File file;
        String string = localApplicationProperties.get(BUNDLE_PATH_KEY);
        if (string != null && (file = new File(string)).exists() && file.isDirectory()) {
            return file;
        }
        return null;
    }

    private void registerApplication() throws RegisterFailedException {
        File file = MacOSXAppAssociationWriter.getBundleFile(this.lap);
        if (file == null) {
            return;
        }
        Trace.println("Register bundle=" + file.getAbsolutePath(), TraceLevel.TEMP);
        int n = MacOSXBundleUtil.registerApplication(file.getAbsolutePath(), true);
        if (n != 0) {
            throw new RegisterFailedException("Failed to register app, errorCode=" + n);
        }
    }
}

