/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.awt.Component;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.EventListenerList;
import org.openide.nodes.Children;
import org.openide.nodes.EntrySupport;
import org.openide.nodes.EntrySupportDefault;
import org.openide.nodes.EntrySupportLazy;
import org.openide.nodes.EntrySupportLazyState;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Parameters;
import org.openide.util.WeakSet;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class FilterNode
extends Node {
    protected static final int DELEGATE_SET_NAME = 1;
    protected static final int DELEGATE_GET_NAME = 2;
    protected static final int DELEGATE_SET_DISPLAY_NAME = 4;
    protected static final int DELEGATE_GET_DISPLAY_NAME = 8;
    protected static final int DELEGATE_SET_SHORT_DESCRIPTION = 16;
    protected static final int DELEGATE_GET_SHORT_DESCRIPTION = 32;
    protected static final int DELEGATE_DESTROY = 64;
    protected static final int DELEGATE_GET_ACTIONS = 128;
    protected static final int DELEGATE_GET_CONTEXT_ACTIONS = 256;
    protected static final int DELEGATE_SET_VALUE = 512;
    protected static final int DELEGATE_GET_VALUE = 1024;
    private static final int DELEGATE_ALL = 2047;
    private static final Map<Class<?>, Boolean> overridesGetDisplayNameCache = new WeakHashMap(27);
    private static final Map<Class<?>, Boolean> replaceProvidedLookupCache = new WeakHashMap(27);
    private static volatile int hashCodeDepth;
    private Node original;
    private PropertyChangeListener propL;
    private NodeListener nodeL;
    private int delegateMask;
    private boolean pchlAttached = false;
    private boolean childrenProvided;
    private boolean lookupProvided;
    private final Object LISTENER_LOCK = new Object();
    static final Logger LOGGER;

    public FilterNode(Node node) {
        this(node, null);
    }

    public FilterNode(Node node, org.openide.nodes.Children children) {
        this(node, children, new FilterLookup());
    }

    public FilterNode(Node node, org.openide.nodes.Children children, Lookup lookup) {
        super(children == null ? (node.isLeaf() ? org.openide.nodes.Children.LEAF : new Children(node)) : children, lookup);
        Parameters.notNull((CharSequence)"original", (Object)node);
        this.childrenProvided = children != null;
        this.lookupProvided = lookup != null && !(lookup instanceof FilterLookup);
        this.original = node;
        this.init();
        Lookup lookup2 = this.internalLookup(false);
        if (lookup2 instanceof FilterLookup) {
            ((FilterLookup)lookup2).ownNode(this);
        } else if (lookup2 == null) {
            this.getNodeListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final Lookup replaceProvidedLookup(Lookup lookup) {
        Map<Class<?>, Boolean> map = replaceProvidedLookupCache;
        synchronized (map) {
            Boolean bl = replaceProvidedLookupCache.get(this.getClass());
            if (bl == null) {
                bl = !this.overridesAMethod("getCookie", Class.class);
                replaceProvidedLookupCache.put(this.getClass(), bl);
            }
            return bl != false ? lookup : null;
        }
    }

    private boolean overridesAMethod(String string, Class ... classArray) {
        if (this.getClass() == FilterNode.class) {
            return false;
        }
        try {
            Method method = this.getClass().getMethod(string, classArray);
            if (method.getDeclaringClass() != FilterNode.class) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Exceptions.printStackTrace((Throwable)noSuchMethodException);
        }
        return false;
    }

    private void init() {
        this.delegateMask = 2047;
    }

    @Override
    void notifyPropertyChangeListenerAdded(PropertyChangeListener propertyChangeListener) {
        if (!this.pchlAttached) {
            this.original.addPropertyChangeListener(this.getPropertyChangeListener());
            this.pchlAttached = true;
        }
    }

    @Override
    void notifyPropertyChangeListenerRemoved(PropertyChangeListener propertyChangeListener) {
        if (this.getPropertyChangeListenersCount() == 0) {
            this.original.removePropertyChangeListener(this.getPropertyChangeListener());
            this.pchlAttached = false;
        }
    }

    protected final void enableDelegation(int n) {
        if ((n & 0xFFFFF800) != 0) {
            throw new IllegalArgumentException("Bad delegation mask: " + n);
        }
        this.delegateMask |= n;
    }

    protected final void disableDelegation(int n) {
        if ((n & 0xFFFFF800) != 0) {
            throw new IllegalArgumentException("Bad delegation mask: " + n);
        }
        this.delegateMask &= ~n;
    }

    private final boolean delegating(int n) {
        return (this.delegateMask & n) != 0;
    }

    @Override
    public Node cloneNode() {
        if (this.isDefault()) {
            return new FilterNode(this.original);
        }
        return new FilterNode(this);
    }

    private boolean checkIfIamAccessibleFromOriginal(Node node) {
        if (this == node) {
            throw new IllegalArgumentException("Node cannot be its own original (even thru indirect chain)");
        }
        if (node instanceof FilterNode) {
            FilterNode filterNode = (FilterNode)node;
            this.checkIfIamAccessibleFromOriginal(filterNode.original);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void changeOriginal(Node node, boolean bl) {
        Lookup lookup;
        Parameters.notNull((CharSequence)"original", (Object)node);
        if (bl && !(this.getChildren() instanceof Children) && this.getChildren() != Children.LEAF) {
            throw new IllegalStateException("Can't change implicitly defined Children on FilterNode");
        }
        assert (this.checkIfIamAccessibleFromOriginal(node)) : "";
        try {
            Children.PR.enterWriteAccess();
            this.original.removeNodeListener(this.getNodeListener());
            if (this.pchlAttached) {
                this.original.removePropertyChangeListener(this.getPropertyChangeListener());
            }
            this.original = node;
            this.original.addNodeListener(this.getNodeListener());
            if (this.pchlAttached) {
                this.original.addPropertyChangeListener(this.getPropertyChangeListener());
            }
            if (bl) {
                if (node.isLeaf() && this.getChildren() != Children.LEAF) {
                    this.setChildren(Children.LEAF);
                } else if (!node.isLeaf() && this.getChildren() == Children.LEAF) {
                    this.setChildren(new Children(node));
                } else if (!node.isLeaf() && this.getChildren() != Children.LEAF) {
                    ((Children)this.getChildren()).changeOriginal(node);
                }
            }
        }
        finally {
            Children.PR.exitWriteAccess();
        }
        if ((lookup = this.internalLookup(false)) instanceof FilterLookup) {
            ((FilterLookup)lookup).checkNode();
        }
        this.fireCookieChange();
        this.fireNameChange(null, null);
        this.fireDisplayNameChange(null, null);
        this.fireShortDescriptionChange(null, null);
        this.fireIconChange();
        this.fireOpenedIconChange();
        this.firePropertySetsChange(null, null);
    }

    @Override
    public void setValue(String string, Object object) {
        if (this.delegating(512)) {
            this.original.setValue(string, object);
        } else {
            super.setValue(string, object);
        }
    }

    @Override
    public Object getValue(String string) {
        if (this.delegating(1024)) {
            return this.original.getValue(string);
        }
        return super.getValue(string);
    }

    @Override
    public void setName(String string) {
        if (this.delegating(1)) {
            this.original.setName(string);
        } else {
            super.setName(string);
        }
    }

    @Override
    public String getName() {
        if (this.delegating(2)) {
            return this.original.getName();
        }
        return super.getName();
    }

    @Override
    public void setDisplayName(String string) {
        if (this.delegating(4)) {
            this.original.setDisplayName(string);
        } else {
            super.setDisplayName(string);
        }
    }

    @Override
    public String getDisplayName() {
        if (this.delegating(8)) {
            return this.original.getDisplayName();
        }
        return super.getDisplayName();
    }

    @Override
    public void setShortDescription(String string) {
        if (this.delegating(16)) {
            this.original.setShortDescription(string);
        } else {
            super.setShortDescription(string);
        }
    }

    @Override
    public String getShortDescription() {
        if (this.delegating(32)) {
            return this.original.getShortDescription();
        }
        return super.getShortDescription();
    }

    @Override
    public Image getIcon(int n) {
        Image image = this.original.getIcon(n);
        if (image != null) {
            return image;
        }
        LOGGER.log(Level.WARNING, "Cannot return null from {0}.getIcon", this.original.getClass().getName());
        return Node.EMPTY.getIcon(n);
    }

    @Override
    public Image getOpenedIcon(int n) {
        return this.original.getOpenedIcon(n);
    }

    @Override
    public HelpCtx getHelpCtx() {
        return this.original.getHelpCtx();
    }

    @Override
    public boolean canRename() {
        return this.original.canRename();
    }

    @Override
    public boolean canDestroy() {
        return this.original.canDestroy();
    }

    @Override
    public void destroy() throws IOException {
        if (this.delegating(64)) {
            this.original.destroy();
        } else {
            super.destroy();
        }
    }

    private final void originalDestroyed() {
        try {
            super.destroy();
        }
        catch (IOException iOException) {
            Logger.getLogger(FilterNode.class.getName()).log(Level.WARNING, null, iOException);
        }
    }

    @Override
    public Node.PropertySet[] getPropertySets() {
        return this.original.getPropertySets();
    }

    @Override
    public Transferable clipboardCopy() throws IOException {
        return this.original.clipboardCopy();
    }

    @Override
    public Transferable clipboardCut() throws IOException {
        return this.original.clipboardCut();
    }

    @Override
    public boolean canCopy() {
        return this.original.canCopy();
    }

    @Override
    public boolean canCut() {
        return this.original.canCut();
    }

    @Override
    public Transferable drag() throws IOException {
        return this.original.drag();
    }

    @Override
    public PasteType getDropType(Transferable transferable, int n, int n2) {
        return this.original.getDropType(transferable, n, n2);
    }

    @Override
    public PasteType[] getPasteTypes(Transferable transferable) {
        return this.original.getPasteTypes(transferable);
    }

    @Override
    public NewType[] getNewTypes() {
        return this.original.getNewTypes();
    }

    @Override
    @Deprecated
    public SystemAction[] getActions() {
        if (this.delegating(128)) {
            return this.original.getActions();
        }
        return super.getActions();
    }

    @Override
    @Deprecated
    public SystemAction[] getContextActions() {
        if (this.delegating(256)) {
            return this.original.getContextActions();
        }
        return super.getContextActions();
    }

    @Override
    @Deprecated
    public SystemAction getDefaultAction() {
        return this.original.getDefaultAction();
    }

    @Override
    public Action[] getActions(boolean bl) {
        if (bl ? !this.delegating(128) || this.overridesAMethod("getContextActions", new Class[0]) : !this.delegating(256) || this.overridesAMethod("getActions", new Class[0])) {
            return super.getActions(bl);
        }
        Action[] actionArray = this.original.getActions(bl);
        return actionArray;
    }

    @Override
    public Action getPreferredAction() {
        Action action = this.overridesAMethod("getDefaultAction", new Class[0]) ? super.getPreferredAction() : this.original.getPreferredAction();
        return action;
    }

    @Override
    public String getHtmlDisplayName() {
        if (this.overridesGetDisplayName()) {
            return null;
        }
        return this.delegating(8) ? this.original.getHtmlDisplayName() : super.getHtmlDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean overridesGetDisplayName() {
        Map<Class<?>, Boolean> map = overridesGetDisplayNameCache;
        synchronized (map) {
            Boolean bl = overridesGetDisplayNameCache.get(this.getClass());
            if (bl == null) {
                bl = this.overridesAMethod("getDisplayName", new Class[0]);
                overridesGetDisplayNameCache.put(this.getClass(), bl);
            }
            return bl;
        }
    }

    @Override
    public boolean hasCustomizer() {
        return this.original.hasCustomizer();
    }

    @Override
    public Component getCustomizer() {
        return this.original.getCustomizer();
    }

    @Override
    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        Lookup lookup = this.internalLookup(true);
        if (lookup != null) {
            Object object = lookup.lookup(clazz);
            return (T)(clazz.isInstance(object) && object instanceof Node.Cookie ? (Node.Cookie)clazz.cast(object) : null);
        }
        return this.original.getCookie(clazz);
    }

    @Override
    public Node.Handle getHandle() {
        if (!this.isDefault()) {
            return null;
        }
        Node.Handle handle = this.original.getHandle();
        if (handle == null) {
            return null;
        }
        return new FilterHandle(handle);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Node)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Node node = FilterNode.getRepresentation(this);
        Node node2 = FilterNode.getRepresentation((Node)object);
        if (node instanceof FilterNode || node2 instanceof FilterNode) {
            return node == node2;
        }
        return node.equals(node2);
    }

    private static Node getRepresentation(Node node) {
        while (node instanceof FilterNode) {
            FilterNode filterNode = (FilterNode)node;
            if (!filterNode.isDefault()) {
                return node;
            }
            node = filterNode.original;
        }
        return node;
    }

    @Override
    public int hashCode() {
        try {
            int n;
            assert (FilterNode.hashCodeLogging(true)) : "";
            int n2 = n = this.isDefault() ? this.original.hashCode() : System.identityHashCode(this);
            assert (FilterNode.hashCodeLogging(false)) : "";
            return n;
        }
        catch (StackError stackError) {
            stackError.add(this);
            throw stackError;
        }
    }

    private static boolean hashCodeLogging(boolean bl) {
        if (hashCodeDepth > 1000) {
            hashCodeDepth = 0;
            throw new StackError();
        }
        hashCodeDepth = bl ? ++hashCodeDepth : --hashCodeDepth;
        return true;
    }

    protected Node getOriginal() {
        return this.original;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeAdapter(this);
    }

    protected NodeListener createNodeListener() {
        return new NodeAdapter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PropertyChangeListener getPropertyChangeListener() {
        Object object = this.LISTENER_LOCK;
        synchronized (object) {
            if (this.propL == null) {
                this.propL = this.createPropertyChangeListener();
            }
            return this.propL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeListener getNodeListener() {
        Object object = this.LISTENER_LOCK;
        synchronized (object) {
            if (this.nodeL == null) {
                this.nodeL = this.createNodeListener();
                this.getOriginal().addNodeListener(this.nodeL);
            }
            return this.nodeL;
        }
    }

    @Override
    final void listenerAdded() {
        this.getNodeListener();
    }

    private boolean isDefault() {
        if (this.getClass() != FilterNode.class) {
            return false;
        }
        return !this.childrenProvided && !this.lookupProvided;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void updateChildren() {
        if (this.isDefault()) {
            org.openide.nodes.Children children = null;
            try {
                Children.PR.enterReadAccess();
                if (this.original.hierarchy == Children.LEAF && this.hierarchy != Children.LEAF) {
                    children = Children.LEAF;
                } else if (this.original.hierarchy != Children.LEAF && this.hierarchy == Children.LEAF) {
                    children = new Children(this.original);
                }
            }
            finally {
                Children.PR.exitReadAccess();
            }
            if (children != null) {
                this.setChildren(children);
            }
        } else {
            super.updateChildren();
        }
    }

    static {
        LOGGER = Logger.getLogger(FilterNode.class.getName());
    }

    private static final class FilterLookup
    extends Lookup {
        private FilterNode node;
        private Lookup delegate;
        private Set<ProxyResult> results;

        FilterLookup() {
        }

        public void ownNode(FilterNode filterNode) {
            this.node = filterNode;
        }

        private <T> T replaceNodes(T t, Class<T> clazz) {
            if (FilterLookup.isNodeQuery(clazz) && t == this.node.getOriginal() && clazz.isInstance(this.node)) {
                return clazz.cast(this.node);
            }
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Lookup checkNode() {
            Lookup lookup = this.node.getOriginal().getLookup();
            if (this.delegate == lookup) {
                return lookup;
            }
            Iterator<ProxyResult> iterator = null;
            Object object = this;
            synchronized (object) {
                if (lookup != this.delegate) {
                    this.delegate = lookup;
                    if (this.results != null) {
                        iterator = new ArrayList<ProxyResult>(this.results).iterator();
                    }
                }
            }
            if (iterator != null) {
                while (iterator.hasNext()) {
                    object = (ProxyResult)((Object)iterator.next());
                    if (!((ProxyResult)((Object)object)).updateLookup(lookup)) continue;
                    ((ProxyResult)((Object)object)).resultChanged(null);
                }
            }
            return this.delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> Lookup.Result<T> lookup(Lookup.Template<T> template) {
            ProxyResult<T> proxyResult = new ProxyResult<T>(template);
            FilterLookup filterLookup = this;
            synchronized (filterLookup) {
                if (this.results == null) {
                    this.results = new WeakSet();
                }
                this.results.add(proxyResult);
            }
            return proxyResult;
        }

        public <T> T lookup(Class<T> clazz) {
            Object object = this.checkNode().lookup(clazz);
            if (object == null && clazz.isInstance(this.node)) {
                object = clazz.cast(this.node);
            }
            return (T)this.replaceNodes(object, clazz);
        }

        private static boolean isNodeQuery(Class<?> clazz) {
            return Node.class.isAssignableFrom(clazz) || clazz.isAssignableFrom(Node.class);
        }

        public <T> Lookup.Item<T> lookupItem(Lookup.Template<T> template) {
            boolean bl = FilterLookup.isNodeQuery(template.getType());
            FilterItem filterItem = this.checkNode().lookupItem(template);
            if (bl && filterItem == null && template.getType().isInstance(this.node) && (template.getInstance() == null || template.getInstance() == this.node)) {
                filterItem = this.checkNode().lookupItem(FilterLookup.wackohacko(template.getId(), template.getInstance()));
            }
            return bl && filterItem != null ? new FilterItem(filterItem, template.getType()) : filterItem;
        }

        private static <T> Lookup.Template<T> wackohacko(String string, T t) {
            return new Lookup.Template(Node.class, string, t);
        }

        private final class FilterItem<T>
        extends Lookup.Item<T> {
            private Lookup.Item<T> delegate;
            private Class<T> clazz;

            FilterItem(Lookup.Item<T> item, Class<T> clazz) {
                this.delegate = item;
                this.clazz = clazz;
            }

            public String getDisplayName() {
                return this.delegate.getDisplayName();
            }

            public String getId() {
                return this.delegate.getId();
            }

            public T getInstance() {
                return (T)FilterLookup.this.replaceNodes(this.delegate.getInstance(), this.clazz);
            }

            public Class<? extends T> getType() {
                return this.delegate.getType();
            }
        }

        private final class ProxyResult<T>
        extends Lookup.Result<T>
        implements LookupListener {
            private Lookup.Template<T> template;
            private Lookup.Result<T> delegate;
            private EventListenerList listeners;

            ProxyResult(Lookup.Template<T> template) {
                this.template = template;
            }

            private Lookup.Result<T> checkResult() {
                this.updateLookup(FilterLookup.this.checkNode());
                return this.delegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean updateLookup(Lookup lookup) {
                Collection collection = this.delegate != null ? this.delegate.allItems() : null;
                Object object = this;
                synchronized (object) {
                    if (this.delegate != null) {
                        this.delegate.removeLookupListener((LookupListener)this);
                    }
                    this.delegate = lookup.lookup(this.template);
                    if (this.template.getType().isAssignableFrom(FilterLookup.this.node.getClass()) && this.delegate.allItems().isEmpty()) {
                        this.delegate = lookup.lookup(FilterLookup.wackohacko(this.template.getId(), this.template.getInstance()));
                    }
                    this.delegate.addLookupListener((LookupListener)this);
                }
                if (collection == null) {
                    return false;
                }
                object = this.delegate.allItems();
                return !collection.equals(object);
            }

            public synchronized void addLookupListener(LookupListener lookupListener) {
                if (this.listeners == null) {
                    this.listeners = new EventListenerList();
                }
                this.listeners.add(LookupListener.class, lookupListener);
            }

            public synchronized void removeLookupListener(LookupListener lookupListener) {
                if (this.listeners != null) {
                    this.listeners.remove(LookupListener.class, lookupListener);
                }
            }

            public Collection<? extends T> allInstances() {
                Collection collection = this.checkResult().allInstances();
                if (FilterLookup.isNodeQuery(this.template.getType())) {
                    ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
                    for (Object e : collection) {
                        arrayList.add(FilterLookup.this.replaceNodes(e, this.template.getType()));
                    }
                    if (arrayList.isEmpty() && this.template.getType().isInstance(FilterLookup.this.node) && (this.template.getInstance() == null || this.template.getInstance() == FilterLookup.this.node)) {
                        arrayList.add(this.template.getType().cast(FilterLookup.this.node));
                    }
                    return arrayList;
                }
                return collection;
            }

            public Set<Class<? extends T>> allClasses() {
                return this.checkResult().allClasses();
            }

            public Collection<? extends Lookup.Item<T>> allItems() {
                return this.checkResult().allItems();
            }

            public void resultChanged(LookupEvent lookupEvent) {
                EventListenerList eventListenerList = this.listeners;
                if (eventListenerList == null) {
                    return;
                }
                Object[] objectArray = eventListenerList.getListenerList();
                if (objectArray.length == 0) {
                    return;
                }
                LookupEvent lookupEvent2 = new LookupEvent((Lookup.Result)this);
                for (int i = objectArray.length - 1; i >= 0; i -= 2) {
                    LookupListener lookupListener = (LookupListener)objectArray[i];
                    lookupListener.resultChanged(lookupEvent2);
                }
            }
        }
    }

    private static final class FilterHandle
    implements Node.Handle {
        static final long serialVersionUID = 7928908039428333839L;
        private Node.Handle original;

        public FilterHandle(Node.Handle handle) {
            this.original = handle;
        }

        @Override
        public Node getNode() throws IOException {
            return new FilterNode(this.original.getNode());
        }

        public String toString() {
            return "FilterHandle[" + this.original + "]";
        }
    }

    private static class ChildrenAdapter
    implements NodeListener {
        private Reference<Children> childrenRef;

        public ChildrenAdapter(Children children) {
            this.childrenRef = new WeakReference<Children>(children);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }

        @Override
        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
            Children children = this.childrenRef.get();
            if (children == null) {
                return;
            }
            children.filterChildrenAdded(nodeMemberEvent);
        }

        @Override
        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
            Children children = this.childrenRef.get();
            if (children == null) {
                return;
            }
            children.filterChildrenRemoved(nodeMemberEvent);
        }

        @Override
        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
            Children children = this.childrenRef.get();
            if (children == null) {
                return;
            }
            children.filterChildrenReordered(nodeReorderEvent);
        }

        @Override
        public void nodeDestroyed(NodeEvent nodeEvent) {
        }
    }

    public static class Children
    extends Children.Keys<Node>
    implements Cloneable {
        protected Node original;
        private ChildrenAdapter nodeL;

        public Children(Node node) {
            this(node, node.getChildren().isLazy());
        }

        private Children(Node node, boolean bl) {
            super(bl);
            this.original = node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        EntrySupport entrySupport() {
            Object object;
            FilterChildrenSupport filterChildrenSupport = null;
            Object object2 = org.openide.nodes.Children.class;
            // MONITORENTER : org.openide.nodes.Children.class
            if (this.getEntrySupport() != null && !this.getEntrySupport().isInitialized()) {
                filterChildrenSupport = (FilterChildrenSupport)((Object)this.getEntrySupport());
            }
            // MONITOREXIT : object2
            if (filterChildrenSupport != null) {
                assert (!Thread.holdsLock(org.openide.nodes.Children.class));
                object2 = this.original.getChildren().entrySupport();
                object = org.openide.nodes.Children.class;
                // MONITORENTER : org.openide.nodes.Children.class
                if (this.getEntrySupport() == filterChildrenSupport && filterChildrenSupport.originalSupport() != object2) {
                    this.setEntrySupport(null);
                }
                // MONITOREXIT : object
            }
            object2 = org.openide.nodes.Children.class;
            // MONITORENTER : org.openide.nodes.Children.class
            if (this.getEntrySupport() != null) {
                // MONITOREXIT : object2
                return this.getEntrySupport();
            }
            // MONITOREXIT : object2
            object2 = this.original.getChildren();
            object = ((org.openide.nodes.Children)object2).entrySupport();
            boolean bl = ((org.openide.nodes.Children)object2).isLazy();
            Class<org.openide.nodes.Children> clazz = org.openide.nodes.Children.class;
            // MONITORENTER : org.openide.nodes.Children.class
            if (this.getEntrySupport() != null) {
                // MONITOREXIT : clazz
                return this.getEntrySupport();
            }
            this.lazySupport = bl;
            EntrySupport entrySupport = this.lazySupport ? new LazySupport(this, (EntrySupportLazy)object) : new DefaultSupport(this, (EntrySupportDefault)object);
            this.setEntrySupport(entrySupport);
            this.postInitializeEntrySupport(entrySupport);
            // MONITOREXIT : clazz
            return this.getEntrySupport();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void changeOriginal(Node node) {
            try {
                boolean bl;
                PR.enterWriteAccess();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("changeOriginal() " + this);
                    LOGGER.finer("    old original children: " + this.original.getChildren());
                    LOGGER.finer("    old original lazy support: " + this.original.getChildren().lazySupport);
                    LOGGER.finer("    new original: " + node);
                    LOGGER.finer("    new original children: " + node.getChildren());
                    LOGGER.finer("    new original lazy support: " + node.getChildren().lazySupport);
                    LOGGER.finer("    Children adapter: " + this.nodeL);
                }
                boolean bl2 = bl = this.nodeL != null;
                if (bl) {
                    this.original.removeNodeListener(this.nodeL);
                    this.nodeL = null;
                }
                this.changeSupport(node);
                if (bl) {
                    this.addNotifyImpl();
                }
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void changeSupport(Node node) {
            Object object;
            boolean bl = LOGGER.isLoggable(Level.FINER);
            boolean bl2 = this.entrySupport().isInitialized();
            boolean bl3 = false;
            if (bl) {
                LOGGER.finer("changeSupport() " + this);
                LOGGER.finer("    newOriginal: " + node);
                LOGGER.finer("    entrySupport().isInitialized(): " + bl2);
                LOGGER.finer("    parent: " + this.parent);
            }
            if (bl2 && this.parent != null && (object = this.entrySupport().snapshot()).size() > 0) {
                int[] nArray = Children.getSnapshotIdxs((List<Node>)object);
                if (node != null) {
                    this.original = node;
                }
                bl3 = true;
                Class<org.openide.nodes.Children> clazz = org.openide.nodes.Children.class;
                // MONITORENTER : org.openide.nodes.Children.class
                this.setEntrySupport(null);
                // MONITOREXIT : clazz
                if (bl) {
                    LOGGER.finer("   firing node removal: " + object);
                }
                this.parent.fireSubNodesChangeIdx(false, nArray, null, Collections.<Node>emptyList(), (List<Node>)object);
            }
            if (!bl3) {
                if (node != null) {
                    this.original = node;
                }
                object = org.openide.nodes.Children.class;
                // MONITORENTER : org.openide.nodes.Children.class
                this.setEntrySupport(null);
                // MONITOREXIT : object
            }
            if (!bl2) {
                if (node != null) return;
            }
            this.entrySupport().notifySetEntries();
            if (bl) {
                LOGGER.log(Level.FINER, "    initializing new support");
            }
            this.entrySupport().getNodesCount(false);
        }

        protected void finalize() {
            if (this.nodeL != null) {
                this.original.removeNodeListener(this.nodeL);
            }
            this.nodeL = null;
        }

        @Override
        public Object clone() {
            return new Children(this.original);
        }

        @Override
        protected void addNotify() {
            this.addNotifyImpl();
        }

        private void addNotifyImpl() {
            this.nodeL = new ChildrenAdapter(this);
            this.original.addNodeListener(this.nodeL);
            this.filterSupport().update();
        }

        @Override
        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            if (this.nodeL != null) {
                this.original.removeNodeListener(this.nodeL);
                this.nodeL = null;
            }
        }

        protected Node copyNode(Node node) {
            return node.cloneNode();
        }

        @Override
        public Node findChild(String string) {
            return this.filterSupport().findChild(string);
        }

        @Override
        protected Node[] createNodes(Node node) {
            return new Node[]{this.copyNode(node)};
        }

        @Override
        @Deprecated
        public boolean add(Node[] nodeArray) {
            return this.original.getChildren().add(nodeArray);
        }

        private FilterChildrenSupport filterSupport() {
            return (FilterChildrenSupport)((Object)this.entrySupport());
        }

        private boolean checkSupportChanged() {
            FilterChildrenSupport filterChildrenSupport = (FilterChildrenSupport)((Object)this.entrySupport());
            EntrySupport entrySupport = this.original.getChildren().entrySupport();
            if (filterChildrenSupport.originalSupport() != entrySupport) {
                assert (MUTEX.isWriteAccess()) : "Should be called only under write access";
                this.changeSupport(null);
                return true;
            }
            return false;
        }

        @Override
        @Deprecated
        public boolean remove(Node[] nodeArray) {
            return this.original.getChildren().remove(nodeArray);
        }

        protected void filterChildrenAdded(NodeMemberEvent nodeMemberEvent) {
            if (this.checkSupportChanged()) {
                return;
            }
            this.filterSupport().filterChildrenAdded(nodeMemberEvent);
        }

        protected void filterChildrenRemoved(NodeMemberEvent nodeMemberEvent) {
            if (this.checkSupportChanged()) {
                return;
            }
            this.filterSupport().filterChildrenRemoved(nodeMemberEvent);
        }

        protected void filterChildrenReordered(NodeReorderEvent nodeReorderEvent) {
            this.filterSupport().filterChildrenReordered(nodeReorderEvent);
        }

        @Override
        public Node[] getNodes(boolean bl) {
            return this.filterSupport().callGetNodes(bl);
        }

        @Override
        public int getNodesCount(boolean bl) {
            return this.filterSupport().callGetNodesCount(bl);
        }

        @Override
        Children.Entry createEntryForKey(Node node) {
            return this.filterSupport().createEntryForKey(node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void switchSupport(boolean bl) {
            try {
                PR.enterWriteAccess();
                ((Children.Keys)this.original.getChildren()).switchSupport(bl);
                super.switchSupport(bl);
            }
            finally {
                PR.exitWriteAccess();
            }
        }

        static interface FilterChildrenSupport {
            public Node[] callGetNodes(boolean var1);

            public int callGetNodesCount(boolean var1);

            public Node findChild(String var1);

            public void filterChildrenAdded(NodeMemberEvent var1);

            public void filterChildrenRemoved(NodeMemberEvent var1);

            public void filterChildrenReordered(NodeReorderEvent var1);

            public void update();

            public Children.Entry createEntryForKey(Node var1);

            public EntrySupport originalSupport();
        }

        private class LazySupport
        extends EntrySupportLazy
        implements FilterChildrenSupport {
            EntrySupportLazy origSupport;

            public LazySupport(org.openide.nodes.Children children2, EntrySupportLazy entrySupportLazy) {
                super(children2);
                this.origSupport = entrySupportLazy;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected EntrySupportLazy.LazySnapshot createSnapshot(List<Children.Entry> list, Map<Children.Entry, EntrySupportLazyState.EntryInfo> map, boolean bl) {
                Object object = this.LOCK;
                synchronized (object) {
                    return bl ? new FilterDelayedLazySnapshot(list, map) : new FilterLazySnapshot(list, map);
                }
            }

            @Override
            public Node[] callGetNodes(boolean bl) {
                Node[] nodeArray = null;
                if (bl) {
                    nodeArray = Children.this.original.getChildren().getNodes(true);
                }
                nodeArray = Children.this.getNodes();
                return nodeArray;
            }

            @Override
            public int callGetNodesCount(boolean bl) {
                return Children.this.original.getChildren().getNodesCount(bl);
            }

            @Override
            public Node findChild(String string) {
                Children.this.original.getChildren().findChild(string);
                return Children.super.findChild(string);
            }

            @Override
            public void filterChildrenAdded(NodeMemberEvent nodeMemberEvent) {
                if (nodeMemberEvent.sourceEntry == null) {
                    this.update();
                } else {
                    this.doRefreshEntry(nodeMemberEvent.sourceEntry);
                }
            }

            @Override
            public void filterChildrenRemoved(NodeMemberEvent nodeMemberEvent) {
                if (nodeMemberEvent.sourceEntry == null) {
                    this.update();
                } else {
                    this.doRefreshEntry(nodeMemberEvent.sourceEntry);
                }
            }

            @Override
            public void filterChildrenReordered(NodeReorderEvent nodeReorderEvent) {
                this.update();
            }

            @Override
            public void update() {
                ChildrenAdapter childrenAdapter;
                boolean bl = LOGGER.isLoggable(Level.FINER);
                if (bl) {
                    LOGGER.finer("updateEntries() " + this);
                }
                if ((childrenAdapter = Children.this.nodeL) != null) {
                    final int n = this.origSupport.getNodesCount(false);
                    MUTEX.postWriteRequest(new Runnable(){

                        @Override
                        public void run() {
                            LazySupport.this.updateEntries(n);
                        }
                    });
                }
            }

            private void updateEntries(int n) {
                boolean bl = LOGGER.isLoggable(Level.FINER);
                if (bl) {
                    LOGGER.finer("updateEntries() " + this);
                }
                if (bl) {
                    LOGGER.finer("    origSupport.getNodesCount(): " + n);
                }
                List<Children.Entry> list = this.origSupport.getEntries();
                if (bl) {
                    LOGGER.finer("    origSupport.getEntries() - size: " + list.size() + " data: " + list);
                }
                ArrayList<FilterNodeEntry> arrayList = new ArrayList<FilterNodeEntry>(list.size());
                for (Children.Entry entry : list) {
                    arrayList.add(new FilterNodeEntry(entry));
                }
                this.setEntries(arrayList);
                if (!this.origSupport.isInitialized()) {
                    this.origSupport.notifySetEntries();
                    return;
                }
            }

            private void doRefreshEntry(Children.Entry entry) {
                this.refreshEntry(new FilterNodeEntry(entry));
            }

            @Override
            public Children.Entry createEntryForKey(Node node) {
                Children.Entry entry = this.origSupport.entryForNode(node);
                return new FilterNodeEntry(entry);
            }

            @Override
            public EntrySupport originalSupport() {
                return this.origSupport;
            }

            private final class FilterNodeEntry
            extends Children.Keys.KE {
                Children.Entry origEntry;

                public FilterNodeEntry(Children.Entry entry) {
                    this.origEntry = entry;
                }

                @Override
                public Object getKey() {
                    return this;
                }

                @Override
                public int getCnt() {
                    return 0;
                }

                @Override
                public Collection<Node> nodes(Object object) {
                    Node node;
                    Node[] nodeArray;
                    if (object != null) {
                        nodeArray = (Node[])object;
                        node = nodeArray.get(this.origEntry);
                    } else {
                        node = LazySupport.this.origSupport.getNode(this.origEntry);
                    }
                    this.key = node;
                    if (node == null || EntrySupportLazy.isDummyNode(node)) {
                        return Collections.emptyList();
                    }
                    nodeArray = Children.this.createNodes(node);
                    if (nodeArray == null) {
                        return Collections.emptyList();
                    }
                    return Arrays.asList(nodeArray);
                }

                @Override
                public int hashCode() {
                    return this.origEntry.hashCode();
                }

                @Override
                public boolean equals(Object object) {
                    return object instanceof FilterNodeEntry ? this.origEntry.equals(((FilterNodeEntry)object).origEntry) : false;
                }

                @Override
                public String toString() {
                    return "FilterNodeEntry[" + this.origEntry + "]@" + Integer.toString(this.hashCode(), 16);
                }
            }

            final class FilterDelayedLazySnapshot
            extends FilterLazySnapshot {
                public FilterDelayedLazySnapshot(List<Children.Entry> list, Map<Children.Entry, EntrySupportLazyState.EntryInfo> map) {
                    super(list, map);
                }
            }

            class FilterLazySnapshot
            extends EntrySupportLazy.LazySnapshot {
                private EntrySupportLazy.LazySnapshot origSnapshot;

                public FilterLazySnapshot(List<Children.Entry> list, Map<Children.Entry, EntrySupportLazyState.EntryInfo> map) {
                    super(list, map);
                    this.origSnapshot = LazySupport.this.origSupport.createSnapshot();
                }

                @Override
                public Node get(Children.Entry entry) {
                    EntrySupportLazyState.EntryInfo entryInfo = (EntrySupportLazyState.EntryInfo)this.entryToInfo.get(entry);
                    Node node = entryInfo.currentNode();
                    if (node == null) {
                        node = entryInfo.getNode(false, this.origSnapshot);
                    }
                    if (EntrySupportLazy.isDummyNode(node)) {
                        LazySupport.this.hideEmpty(null, entry);
                    }
                    return node;
                }
            }
        }

        private class DefaultSupport
        extends EntrySupportDefault
        implements FilterChildrenSupport {
            EntrySupportDefault origSupport;

            public DefaultSupport(org.openide.nodes.Children children2, EntrySupportDefault entrySupportDefault) {
                super(children2);
                this.origSupport = entrySupportDefault;
            }

            @Override
            protected EntrySupportDefault.DefaultSnapshot createSnapshot() {
                Object[] objectArray;
                EntrySupportDefault.DefaultSnapshot defaultSnapshot = super.createSnapshot();
                defaultSnapshot.holder = objectArray = new Object[]{defaultSnapshot.holder, this.origSupport.createSnapshot()};
                return defaultSnapshot;
            }

            @Override
            public Node[] callGetNodes(boolean bl) {
                Node[] nodeArray = null;
                if (bl) {
                    nodeArray = Children.this.original.getChildren().getNodes(true);
                }
                nodeArray = Children.this.getNodes();
                return nodeArray;
            }

            @Override
            public int callGetNodesCount(boolean bl) {
                int n = 0;
                if (bl) {
                    n = Children.this.original.getChildren().getNodesCount(true);
                }
                int n2 = Children.this.getNodesCount();
                org.openide.nodes.Children.LOG.log(Level.FINEST, "Count {1} gives {2}", new Object[]{n, n2});
                return n2;
            }

            @Override
            public Node findChild(String string) {
                Node node = Children.this.original.getChildren().findChild(string);
                return Children.super.findChild(string);
            }

            @Override
            public void filterChildrenAdded(NodeMemberEvent nodeMemberEvent) {
                this.updateKeys();
            }

            @Override
            public void filterChildrenRemoved(NodeMemberEvent nodeMemberEvent) {
                this.updateKeys();
            }

            @Override
            public void filterChildrenReordered(NodeReorderEvent nodeReorderEvent) {
                this.updateKeys();
            }

            @Override
            public void update() {
                this.updateKeys();
            }

            private void updateKeys() {
                ChildrenAdapter childrenAdapter;
                boolean bl = LOGGER.isLoggable(Level.FINER);
                if (bl) {
                    LOGGER.finer("updateKeys() " + this);
                }
                if ((childrenAdapter = Children.this.nodeL) != null) {
                    if (bl) {
                        LOGGER.finer("    getting original nodes");
                    }
                    Object[] objectArray = Children.this.original.getChildren().getNodes();
                    if (bl) {
                        LOGGER.finer("    setKeys(), keys: " + Arrays.toString(objectArray));
                    }
                    Children.this.setKeys(objectArray);
                    if (!this.origSupport.isInitialized()) {
                        this.origSupport.notifySetEntries();
                    }
                }
            }

            @Override
            public Children.Entry createEntryForKey(Node node) {
                return new Children.Keys.KE(node);
            }

            @Override
            public EntrySupport originalSupport() {
                return this.origSupport;
            }
        }
    }

    protected static class NodeAdapter
    implements NodeListener {
        private Reference<FilterNode> fnRef;

        public NodeAdapter(FilterNode filterNode) {
            this.fnRef = new WeakReference<FilterNode>(filterNode);
        }

        @Override
        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FilterNode filterNode = this.fnRef.get();
            if (filterNode == null) {
                return;
            }
            this.propertyChange(filterNode, propertyChangeEvent);
        }

        protected void propertyChange(FilterNode filterNode, PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("parentNode")) {
                return;
            }
            if (string.equals("displayName")) {
                filterNode.fireOwnPropertyChange("displayName", (String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("name")) {
                filterNode.fireOwnPropertyChange("name", (String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("shortDescription")) {
                filterNode.fireOwnPropertyChange("shortDescription", (String)propertyChangeEvent.getOldValue(), (String)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("icon")) {
                filterNode.fireIconChange();
                return;
            }
            if (string.equals("openedIcon")) {
                filterNode.fireOpenedIconChange();
                return;
            }
            if (string.equals("propertySets")) {
                filterNode.firePropertySetsChange((Node.PropertySet[])propertyChangeEvent.getOldValue(), (Node.PropertySet[])propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("cookie")) {
                filterNode.fireCookieChange();
                return;
            }
            if (string.equals("leaf")) {
                filterNode.updateChildren();
            }
        }

        @Override
        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        }

        @Override
        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        }

        @Override
        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        }

        @Override
        public final void nodeDestroyed(NodeEvent nodeEvent) {
            FilterNode filterNode = this.fnRef.get();
            if (filterNode == null) {
                return;
            }
            filterNode.originalDestroyed();
        }

        static Set<NodeListener> checkDormant(NodeListener nodeListener, Set<NodeListener> set) {
            if (nodeListener instanceof NodeAdapter && ((NodeAdapter)nodeListener).fnRef.get() == null) {
                HashSet<NodeListener> hashSet = new HashSet<NodeListener>();
                if (set != null) {
                    hashSet.addAll(set);
                }
                hashSet.add(nodeListener);
                return hashSet;
            }
            return set;
        }
    }

    protected static class PropertyChangeAdapter
    implements PropertyChangeListener {
        private Reference<FilterNode> fnRef;

        public PropertyChangeAdapter(FilterNode filterNode) {
            this.fnRef = new WeakReference<FilterNode>(filterNode);
        }

        @Override
        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FilterNode filterNode = this.fnRef.get();
            if (filterNode == null) {
                return;
            }
            this.propertyChange(filterNode, propertyChangeEvent);
        }

        protected void propertyChange(FilterNode filterNode, PropertyChangeEvent propertyChangeEvent) {
            filterNode.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }

        static Set<PropertyChangeListener> checkDormant(PropertyChangeListener propertyChangeListener, Set<PropertyChangeListener> set) {
            if (propertyChangeListener instanceof PropertyChangeAdapter && ((PropertyChangeAdapter)propertyChangeListener).fnRef.get() == null) {
                HashSet<PropertyChangeListener> hashSet = new HashSet<PropertyChangeListener>();
                if (set != null) {
                    hashSet.addAll(set);
                }
                hashSet.add(propertyChangeListener);
                return hashSet;
            }
            return set;
        }
    }

    private static class StackError
    extends StackOverflowError {
        private IdentityHashMap<FilterNode, FilterNode> nodes;

        private StackError() {
        }

        public void add(FilterNode filterNode) {
            if (this.nodes == null) {
                this.nodes = new IdentityHashMap();
            }
            if (!this.nodes.containsKey(filterNode)) {
                this.nodes.put(filterNode, filterNode);
            }
        }

        @Override
        public String getMessage() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("StackOver in FilterNodes:\n");
            for (FilterNode filterNode : this.nodes.keySet()) {
                stringBuffer.append("  class: ");
                stringBuffer.append(filterNode.getClass().getName());
                stringBuffer.append(" id: ");
                stringBuffer.append(Integer.toString(System.identityHashCode(filterNode), 16));
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
    }
}

