/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.toolbar;

import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.contributions.UserInterfaceContribution;
import com.jrockit.mc.components.ui.design.actions.ExportAction;
import com.jrockit.mc.components.ui.design.actions.ImportAction;
import com.jrockit.mc.components.ui.design.view.toolbar.DeleteAction;
import com.jrockit.mc.components.ui.design.view.toolbar.EditAction;
import com.jrockit.mc.components.ui.design.view.toolbar.ExportHelpContextsAction;
import com.jrockit.mc.components.ui.design.view.toolbar.ExportToUIPluginAction;
import com.jrockit.mc.components.ui.design.view.toolbar.NewMenu;
import com.jrockit.mc.components.ui.design.view.toolbar.SwapAction;
import com.jrockit.mc.components.ui.design.view.toolbar.TabPageLabelProvider;
import com.jrockit.mc.components.ui.design.view.toolbar.ToolbarBaseMenu;
import com.jrockit.mc.components.ui.l10n.LocalizationEditAction;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.tab.BaseDescriptor;
import com.jrockit.mc.components.ui.tab.TabDescriptorRepository;
import com.jrockit.mc.components.ui.tab.TabGroupDescriptor;
import com.jrockit.mc.components.ui.tab.TabItemDescriptor;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.Viewer;

final class MainMenu
extends ToolbarBaseMenu {
    public MainMenu(Viewer viewer, TabPageLabelProvider provider) {
        super("#PopupMenu", viewer, provider);
    }

    @Override
    protected void populateForSelected(TabDescriptorRepository tabDescriptorRepository, Object selectedObject) {
        BaseDescriptor selected = this.getBaseDescriptor(selectedObject);
        List<? extends BaseDescriptor> belongsToList = this.getBelongsToList(tabDescriptorRepository, selected);
        if (this.isExtendible(selected)) {
            this.add((IContributionItem)this.createNewMenu(tabDescriptorRepository, selected));
        }
        this.addSeparator();
        if (selected != null) {
            this.addDeleteAction(belongsToList, selected);
            this.addSeparator();
        }
        this.addImportExport(tabDescriptorRepository, selected);
        if (selected != null) {
            this.addEditAction(selected);
        }
        this.addSeparator();
        if (selectedObject instanceof UserInterfaceContribution) {
            this.addExportToPLugIn((UserInterfaceContribution)selectedObject);
        }
        this.addLocalization(selectedObject);
        this.addHelpContextExport(selectedObject);
    }

    private void addHelpContextExport(Object selectedObject) {
        if (selectedObject instanceof UserInterfaceContribution) {
            this.add((IAction)new ExportHelpContextsAction((UserInterfaceContribution)selectedObject));
        }
    }

    private void addLocalization(Object selected) {
        if (selected instanceof BaseDescriptor) {
            this.add((IAction)new LocalizationEditAction(selected, ((BaseDescriptor)selected).getName()));
        }
        if (selected instanceof UserInterfaceContribution) {
            this.add((IAction)new LocalizationEditAction(selected, ((UserInterfaceContribution)selected).getContributionDescriptor().getName()));
        }
    }

    private BaseDescriptor getBaseDescriptor(Object selectedObject) {
        return (BaseDescriptor)(selectedObject instanceof BaseDescriptor ? selectedObject : null);
    }

    private void addExportToPLugIn(UserInterfaceContribution contribution) {
        this.add((IAction)new ExportToUIPluginAction(this.getViewer().getControl().getShell(), contribution));
    }

    private boolean isExtendible(BaseDescriptor selected) {
        return selected == null || selected instanceof TabGroupDescriptor;
    }

    protected void addMove(BaseDescriptor selected, List<? extends BaseDescriptor> belongsToList) {
        if (belongsToList.size() > 0) {
            this.addMoveUpAction(belongsToList, selected);
            this.addMoveDownAction(belongsToList, selected);
        }
    }

    private void addImportExport(TabDescriptorRepository tabDescriptorRepository, BaseDescriptor baseDescriptor) {
        if (baseDescriptor == null) {
            this.addImportGroup(tabDescriptorRepository.getGroups());
        }
        if (baseDescriptor instanceof TabGroupDescriptor) {
            TabGroupDescriptor tgd = (TabGroupDescriptor)baseDescriptor;
            this.addImportGroup(tgd.getGroups());
            this.add(this.createExportAction(baseDescriptor, Messages.DESIGN_MENU_EXPORT_GROUP_TEXT));
            this.addSeparator();
            this.addRefreshAction(ImportAction.createListAction(this.getShell(), tgd.getTabs(), Messages.DESIGN_MENU_IMPORT_TAB_TEXT, new TabItemDescriptor()));
        }
        if (baseDescriptor instanceof TabItemDescriptor) {
            this.add(this.createExportAction(baseDescriptor, Messages.DESIGN_MENU_EXPORT_TAB_TEXT));
        }
        this.addSeparator();
    }

    private void addImportGroup(List<TabGroupDescriptor> importIntoGroups) {
        this.addRefreshAction(ImportAction.createListAction(this.getShell(), importIntoGroups, Messages.DESIGN_MENU_IMPORT_GROUP_TEXT, new TabGroupDescriptor()));
    }

    private void addSeparator() {
        this.add((IContributionItem)new Separator());
    }

    private IAction createExportAction(BaseDescriptor baseDescriptor, String title) {
        return new ExportAction(this.getShell(), title, baseDescriptor.getIdentifier(), baseDescriptor);
    }

    private MenuManager createNewMenu(TabDescriptorRepository tabDescriptorRepository, BaseDescriptor selected) {
        return new NewMenu(this.getViewer(), this.getTabImageProvider());
    }

    private List<? extends BaseDescriptor> getBelongsToList(TabDescriptorRepository rep, BaseDescriptor descriptor) {
        List<? extends BaseDescriptor> list = this.searchList(rep.getGroups(), descriptor);
        if (list == null) {
            list = rep.getGroups();
        }
        return list;
    }

    private List<? extends BaseDescriptor> searchList(List<? extends BaseDescriptor> list, BaseDescriptor searchItem) {
        for (BaseDescriptor baseDescriptor : list) {
            if (!(baseDescriptor instanceof TabGroupDescriptor)) continue;
            TabGroupDescriptor tg = (TabGroupDescriptor)baseDescriptor;
            if (tg.getTabs().contains(searchItem)) {
                return tg.getTabs();
            }
            List<? extends BaseDescriptor> result = this.searchList(tg.getGroups(), searchItem);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void addMoveDownAction(List<? extends BaseDescriptor> belongingList, BaseDescriptor selected) {
        int index = belongingList.indexOf(selected);
        if (index < belongingList.size() - 1) {
            SwapAction sa = new SwapAction(Messages.DESIGN_MENU_MOVE_TAB_ITEM_DOWN_TEXT, belongingList, index, index + 1);
            sa.setImageDescriptor(ComponentsPlugin.getDefault().getMCImageDescriptor("down_arrow.gif"));
            this.addRefreshAction((IAction)sa);
        }
    }

    private void addMoveUpAction(List<? extends BaseDescriptor> belongingList, BaseDescriptor selected) {
        int index = belongingList.indexOf(selected);
        if (index != 0) {
            SwapAction sa = new SwapAction(Messages.DESIGN_MENU_MOVE_TAB_ITEM_UP_TEXT, belongingList, index, index - 1);
            sa.setImageDescriptor(ComponentsPlugin.getDefault().getMCImageDescriptor("up_arrow.gif"));
            this.addRefreshAction((IAction)sa);
        }
    }

    private void addEditAction(BaseDescriptor editable) {
        this.addRefreshAction((IAction)new EditAction(editable));
    }

    private void addDeleteAction(List<? extends BaseDescriptor> belongingList, BaseDescriptor selected) {
        this.addRefreshAction((IAction)new DeleteAction(belongingList, selected));
    }
}

