/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.actions;

import com.jrockit.mc.console.ui.messages.internal.Messages;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.IMBeanServerChangeListener;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.IRefreshable;
import javax.management.ObjectName;
import org.eclipse.jface.action.Action;

public final class MBeanAutomaticRefreshAction
extends Action {
    private final IConnectionHandle m_connectionHandle;
    private final IRefreshable m_refreshable;
    private final IMBeanServerChangeListener m_mbeanListener;

    public MBeanAutomaticRefreshAction(IConnectionHandle connectionHandle, IRefreshable refreshable) {
        super("", 2);
        this.setText(Messages.MBeanAutomaticRefreshAction_MBEAN_STRUCTURA_REFRESH_ACTION_TEXT);
        this.setToolTipText(Messages.MBeanAutomaticRefreshAction_MBEAN_STRUCTURA_REFRESH_ACTION_TOOLTIP);
        this.setChecked(true);
        this.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("refresh_tab.gif"));
        this.setDisabledImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("refresh_tab_grey.gif"));
        this.setId("refresh");
        this.m_connectionHandle = connectionHandle;
        this.m_refreshable = refreshable;
        this.m_mbeanListener = this.createListener();
        this.setChecked(true);
        this.enabledStructuralMBeanUpdates();
    }

    private IMBeanServerChangeListener createListener() {
        return new IMBeanServerChangeListener(){

            public void mbeanUnregistered(ObjectName mbean) {
                MBeanAutomaticRefreshAction.this.refresh();
            }

            public void mbeanRegistered(ObjectName mbean) {
                MBeanAutomaticRefreshAction.this.refresh();
            }
        };
    }

    public void run() {
        if (this.isChecked()) {
            this.enabledStructuralMBeanUpdates();
            this.refresh();
        } else {
            this.disableStructuralMBeanUpdates();
        }
    }

    private void refresh() {
        this.m_refreshable.refresh();
    }

    private void disableStructuralMBeanUpdates() {
        ((IMBeanHelperService)this.m_connectionHandle.getServiceOrDummy(IMBeanHelperService.class)).removeMBeanServerChangeListener(this.m_mbeanListener);
    }

    private void enabledStructuralMBeanUpdates() {
        ((IMBeanHelperService)this.m_connectionHandle.getServiceOrDummy(IMBeanHelperService.class)).addMBeanServerChangeListener(this.m_mbeanListener);
    }
}

