/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CircularArray<T>
implements Collection<T>,
Iterable<T> {
    private final T[] m_array;
    private int m_startIndex;
    private int m_endIndex;
    private CircularArrayFullCallback<T> m_callback;

    public CircularArray(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("The max size " + maxSize + " isn't allowed!");
        }
        this.m_array = CircularArray.createArray(maxSize);
    }

    private static <T> T[] createArray(int size) {
        return new Object[size + 1];
    }

    @Override
    public boolean add(T object) {
        int newEnd = this.inc(this.m_endIndex);
        if (newEnd == this.m_startIndex && this.m_callback != null) {
            this.m_callback.onCircularArrayFull(this);
        }
        this.m_array[this.m_endIndex] = object;
        this.m_endIndex = newEnd;
        if (this.m_endIndex == this.m_startIndex) {
            this.m_startIndex = this.inc(this.m_startIndex);
        }
        return true;
    }

    private int inc(int index) {
        return ++index % this.m_array.length;
    }

    public T get(int index) throws IndexOutOfBoundsException {
        int size = this.size();
        if (index >= size) {
            throw new IndexOutOfBoundsException("Index was: " + index + ", but size was: " + size);
        }
        return this.m_array[(this.m_startIndex + index) % this.m_array.length];
    }

    @Override
    public int size() {
        if (this.m_startIndex == this.m_endIndex) {
            return 0;
        }
        if (this.m_endIndex > this.m_startIndex) {
            return this.m_endIndex - this.m_startIndex;
        }
        return this.m_array.length - this.m_startIndex + this.m_endIndex;
    }

    public void removeFirst() {
        if (!this.isEmpty()) {
            this.m_array[this.m_startIndex] = null;
            this.m_startIndex = this.inc(this.m_startIndex);
        }
    }

    public void removeLast() {
        if (!this.isEmpty()) {
            if (this.m_endIndex > 0) {
                this.m_array[this.m_endIndex--] = null;
            } else {
                this.m_array[0] = null;
                this.m_endIndex = this.m_array.length - 1;
            }
        }
    }

    public int getCapacity() {
        return this.m_array.length - 1;
    }

    public void setCallback(CircularArrayFullCallback<T> callback) {
        this.m_callback = callback;
    }

    public CircularArrayFullCallback<T> getCallback() {
        return this.m_callback;
    }

    @Override
    public boolean isEmpty() {
        return this.m_startIndex == this.m_endIndex;
    }

    public T getLast() {
        if (this.isEmpty()) {
            return null;
        }
        int lastElement = this.m_endIndex == 0 ? this.m_array.length - 1 : this.m_endIndex - 1;
        return this.m_array[lastElement];
    }

    public T getFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.m_array[this.m_startIndex];
    }

    @Override
    public void clear() {
        while (!this.isEmpty()) {
            this.removeFirst();
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        if (collection.size() > this.getCapacity() - this.size()) {
            throw new IllegalArgumentException("This array isn't big enough, or too full, to accept the elements from the specified array");
        }
        for (T t : collection) {
            this.add(t);
        }
        return true;
    }

    @Override
    public boolean contains(Object object) {
        for (T element : this) {
            if (!(element == null ? object == null : element.equals(object))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException("containsAll not supported");
    }

    @Override
    public Iterator<T> iterator() {
        return new CircularArrayIterator();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("remove not supported");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("removeAll not supported");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("retainAll not supported");
    }

    public List<T> toList() {
        ArrayList<T> list = new ArrayList<T>(this.size());
        for (T t : this) {
            list.add(t);
        }
        return list;
    }

    @Override
    public Object[] toArray() {
        return this.toList().toArray();
    }

    @Override
    public <R> R[] toArray(R[] a) {
        return this.toList().toArray(a);
    }

    public static interface CircularArrayFullCallback<T> {
        public void onCircularArrayFull(CircularArray<T> var1);
    }

    private class CircularArrayIterator
    implements Iterator<T> {
        private int m_index;
        private final int m_startIndex;
        private final int m_endIndex;

        public CircularArrayIterator() {
            this.m_startIndex = CircularArray.this.m_startIndex;
            this.m_endIndex = CircularArray.this.m_endIndex;
        }

        @Override
        public boolean hasNext() {
            return this.m_index < CircularArray.this.size();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.m_startIndex != CircularArray.this.m_startIndex || this.m_endIndex != CircularArray.this.m_endIndex) {
                throw new ConcurrentModificationException("The circular array has been modified since the iterator was created!");
            }
            return CircularArray.this.get(this.m_index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }
    }
}

