/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr.internal;

import com.jrockit.mc.rjmx.services.flr.EventOptionID;
import com.jrockit.mc.rjmx.services.flr.EventTypeID;
import com.jrockit.mc.rjmx.services.flr.IConvertibleValue;
import com.jrockit.mc.rjmx.services.flr.IEventSettingsHolder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class EventSettingsHolder
implements IEventSettingsHolder {
    Map<EventOptionID, IConvertibleValue<?>> perOption = new HashMap();
    Map<EventTypeID, Map<EventOptionID, IConvertibleValue<?>>> perType = new HashMap();

    public EventSettingsHolder() {
    }

    public EventSettingsHolder(IEventSettingsHolder holder) {
        for (Map.Entry<EventOptionID, IConvertibleValue<?>> entry : holder.getEventOptions().entrySet()) {
            this.add(entry.getKey(), entry.getValue().toCanonical());
        }
    }

    public void add(EventOptionID optionID, IConvertibleValue<?> value) {
        this.perOption.put(optionID, value);
        EventTypeID typeID = optionID.getEventTypeID();
        Map<EventOptionID, IConvertibleValue<?>> tinyMap = this.perType.get(typeID);
        if (tinyMap == null) {
            tinyMap = new HashMap();
            this.perType.put(typeID, tinyMap);
        }
        tinyMap.put(optionID, value);
    }

    @Override
    public IConvertibleValue<?> getEventOption(EventOptionID optionID) {
        return this.perOption.get(optionID);
    }

    @Override
    public Map<EventOptionID, IConvertibleValue<?>> getEventOptions() {
        return Collections.unmodifiableMap(this.perOption);
    }

    @Override
    public Map<EventOptionID, IConvertibleValue<?>> getEventOptionsFor(EventTypeID eventTypeID) {
        Map<EventOptionID, IConvertibleValue<?>> map = this.perType.get(eventTypeID);
        if (map == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }
}

