/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.common.util.Messages;
import com.jrockit.mc.common.util.TimeRangeToolkit;
import com.jrockit.mc.ui.model.fields.NumberField;
import com.jrockit.mc.ui.model.fields.TimespanParser;
import java.text.ParseException;

public final class NanosTimeSpanField
extends NumberField {
    private static final String NO_TIME_SPAN = "0 " + Messages.getString((String)"TimeRangeToolkit_SECONDS_SHORT", (String)"s");

    public NanosTimeSpanField(int id) {
        super(id);
    }

    @Override
    public String formatObject(Object object) {
        if (object instanceof Number) {
            if (((Number)object).doubleValue() == 0.0) {
                return NO_TIME_SPAN;
            }
            return TimeRangeToolkit.convertNanosToString((long)((Number)object).longValue());
        }
        return super.formatObject(object);
    }

    @Override
    public Object parse(Tokenizer tokenizer) throws ParseException {
        return TimespanParser.parse(tokenizer);
    }
}

