/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import org.openni.Context;
import org.openni.EnumerationErrors;
import org.openni.GeneralException;
import org.openni.MapGenerator;
import org.openni.MapOutputMode;
import org.openni.NativeMethods;
import org.openni.NodeType;
import org.openni.OutArg;
import org.openni.Plane3D;
import org.openni.Point3D;
import org.openni.Query;
import org.openni.SceneMap;
import org.openni.SceneMetaData;
import org.openni.StatusException;
import org.openni.WrapperUtils;

public class SceneAnalyzer
extends MapGenerator {
    private SceneMap currSceneMap;
    private int currSceneMapFrameID;

    SceneAnalyzer(Context context, long l, boolean bl) throws GeneralException {
        super(context, l, bl);
    }

    public static SceneAnalyzer create(Context context, Query query, EnumerationErrors enumerationErrors) throws GeneralException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnCreateSceneAnalyzer(context.toNative(), outArg, query == null ? 0L : query.toNative(), enumerationErrors == null ? 0L : enumerationErrors.toNative());
        WrapperUtils.throwOnError(n);
        SceneAnalyzer sceneAnalyzer = (SceneAnalyzer)context.createProductionNodeObject((Long)outArg.value, NodeType.SCENE);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return sceneAnalyzer;
    }

    public static SceneAnalyzer create(Context context, Query query) throws GeneralException {
        return SceneAnalyzer.create(context, query, null);
    }

    public static SceneAnalyzer create(Context context) throws GeneralException {
        return SceneAnalyzer.create(context, null, null);
    }

    public SceneMap getSceneMap() throws GeneralException {
        int n = this.getFrameID();
        if (this.currSceneMap == null || this.currSceneMapFrameID != n) {
            long l = NativeMethods.xnGetLabelMap(this.toNative());
            MapOutputMode mapOutputMode = this.getMapOutputMode();
            this.currSceneMap = new SceneMap(l, mapOutputMode.getXRes(), mapOutputMode.getYRes());
            this.currSceneMapFrameID = n;
        }
        return this.currSceneMap;
    }

    public void getMetaData(SceneMetaData sceneMetaData) {
        NativeMethods.xnGetSceneMetaData(this.toNative(), sceneMetaData);
    }

    public SceneMetaData getMetaData() {
        SceneMetaData sceneMetaData = new SceneMetaData();
        this.getMetaData(sceneMetaData);
        return sceneMetaData;
    }

    public Plane3D getFloor() throws StatusException {
        OutArg<Point3D> outArg = new OutArg<Point3D>();
        OutArg<Point3D> outArg2 = new OutArg<Point3D>();
        int n = NativeMethods.xnGetFloor(this.toNative(), outArg, outArg2);
        WrapperUtils.throwOnError(n);
        return new Plane3D((Point3D)outArg.value, (Point3D)outArg2.value);
    }
}

