/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import org.openni.Context;
import org.openni.EnumerationErrors;
import org.openni.GeneralException;
import org.openni.IRMap;
import org.openni.IRMetaData;
import org.openni.MapGenerator;
import org.openni.MapOutputMode;
import org.openni.NativeMethods;
import org.openni.NodeType;
import org.openni.OutArg;
import org.openni.Query;
import org.openni.WrapperUtils;

public class IRGenerator
extends MapGenerator {
    private IRMap currIRMap;
    private int currIRMapFrameID;

    IRGenerator(Context context, long l, boolean bl) throws GeneralException {
        super(context, l, bl);
    }

    public static IRGenerator create(Context context, Query query, EnumerationErrors enumerationErrors) throws GeneralException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnCreateIRGenerator(context.toNative(), outArg, query == null ? 0L : query.toNative(), enumerationErrors == null ? 0L : enumerationErrors.toNative());
        WrapperUtils.throwOnError(n);
        IRGenerator iRGenerator = (IRGenerator)context.createProductionNodeObject((Long)outArg.value, NodeType.IR);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return iRGenerator;
    }

    public static IRGenerator create(Context context, Query query) throws GeneralException {
        return IRGenerator.create(context, query, null);
    }

    public static IRGenerator create(Context context) throws GeneralException {
        return IRGenerator.create(context, null, null);
    }

    public IRMap getIRMap() throws GeneralException {
        int n = this.getFrameID();
        if (this.currIRMap == null || this.currIRMapFrameID != n) {
            long l = NativeMethods.xnGetIRMap(this.toNative());
            MapOutputMode mapOutputMode = this.getMapOutputMode();
            this.currIRMap = new IRMap(l, mapOutputMode.getXRes(), mapOutputMode.getYRes());
            this.currIRMapFrameID = n;
        }
        return this.currIRMap;
    }

    public void getMetaData(IRMetaData iRMetaData) {
        NativeMethods.xnGetIRMetaData(this.toNative(), iRMetaData);
    }

    public IRMetaData getMetaData() {
        IRMetaData iRMetaData = new IRMetaData();
        this.getMetaData(iRMetaData);
        return iRMetaData;
    }
}

