/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import org.openni.CapabilityBase;
import org.openni.IStateChangedObservable;
import org.openni.NativeMethods;
import org.openni.OutArg;
import org.openni.ProductionNode;
import org.openni.StateChangedObservable;
import org.openni.StatusException;
import org.openni.WrapperUtils;
import org.openni.XYCoordinates;

public class AlternativeViewpointCapability
extends CapabilityBase {
    private StateChangedObservable viewPointChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String string, OutArg<Long> outArg) {
            return NativeMethods.xnRegisterToViewPointChange(AlternativeViewpointCapability.this.toNative(), this, string, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromViewPointChange(AlternativeViewpointCapability.this.toNative(), l);
        }
    };

    public AlternativeViewpointCapability(ProductionNode productionNode) throws StatusException {
        super(productionNode);
    }

    public boolean isViewpointSupported(ProductionNode productionNode) {
        return NativeMethods.xnIsViewPointSupported(this.toNative(), productionNode.toNative());
    }

    public void setViewpoint(ProductionNode productionNode) throws StatusException {
        int n = NativeMethods.xnSetViewPoint(this.toNative(), productionNode.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void resetViewpoint() throws StatusException {
        int n = NativeMethods.xnResetViewPoint(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public boolean isViewpointAs(ProductionNode productionNode) {
        return NativeMethods.xnIsViewPointAs(this.toNative(), productionNode.toNative());
    }

    public XYCoordinates getPixelCoordinatesInViewpoint(ProductionNode productionNode, int n, int n2) throws StatusException {
        OutArg<Integer> outArg = new OutArg<Integer>();
        OutArg<Integer> outArg2 = new OutArg<Integer>();
        int n3 = NativeMethods.xnGetPixelCoordinatesInViewPoint(this.toNative(), productionNode.toNative(), n, n2, outArg, outArg2);
        WrapperUtils.throwOnError(n3);
        return new XYCoordinates((Integer)outArg.value, (Integer)outArg2.value);
    }

    public IStateChangedObservable getViewPointChangedEvent() {
        return this.viewPointChanged;
    }
}

