/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import java.util.Hashtable;
import org.openni.AudioGenerator;
import org.openni.Codec;
import org.openni.DepthGenerator;
import org.openni.Device;
import org.openni.EnumerationErrors;
import org.openni.ErrorStateEventArgs;
import org.openni.GeneralException;
import org.openni.Generator;
import org.openni.GestureGenerator;
import org.openni.HandsGenerator;
import org.openni.IObservable;
import org.openni.IRGenerator;
import org.openni.ImageGenerator;
import org.openni.License;
import org.openni.MapGenerator;
import org.openni.NativeMethods;
import org.openni.NodeCreatedEventArgs;
import org.openni.NodeDestroyedEventArgs;
import org.openni.NodeInfo;
import org.openni.NodeInfoList;
import org.openni.NodeType;
import org.openni.ObjectWrapper;
import org.openni.Observable;
import org.openni.OutArg;
import org.openni.Player;
import org.openni.ProductionNode;
import org.openni.Query;
import org.openni.Recorder;
import org.openni.SceneAnalyzer;
import org.openni.ScriptNode;
import org.openni.StatusException;
import org.openni.UserGenerator;
import org.openni.Version;
import org.openni.WrapperUtils;

public class Context
extends ObjectWrapper {
    private Observable<ErrorStateEventArgs> errorStateChangedEvent;
    private Observable<NodeCreatedEventArgs> nodeCreatedEvent;
    private Observable<NodeDestroyedEventArgs> nodeDestroyedEvent;
    private Hashtable<Long, ProductionNode> allNodes = new Hashtable();
    private static Hashtable<Long, Context> allContexts = new Hashtable();

    public Context() throws GeneralException {
        this(Context.init(), false);
    }

    public static Context createFromXmlFile(String string, OutArg<ScriptNode> outArg) throws GeneralException {
        OutArg<Long> outArg2 = new OutArg<Long>();
        long l = Context.initFromXmlEx(string, outArg2);
        Context context = new Context(l, false);
        outArg.value = new ScriptNode(context, (Long)outArg2.value, false);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context fromNative(long l) throws GeneralException {
        Hashtable<Long, Context> hashtable = allContexts;
        synchronized (hashtable) {
            if (allContexts.containsKey(l)) {
                return allContexts.get(l);
            }
            return new Context(l);
        }
    }

    public static Version getVersion() throws StatusException {
        OutArg<Version> outArg = new OutArg<Version>();
        int n = NativeMethods.xnGetVersion(outArg);
        WrapperUtils.throwOnError(n);
        return (Version)outArg.value;
    }

    public ScriptNode runXmlScriptFromFile(String string) throws GeneralException {
        EnumerationErrors enumerationErrors = new EnumerationErrors();
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnContextRunXmlScriptFromFileEx(this.toNative(), string, enumerationErrors.toNative(), outArg);
        WrapperUtils.checkEnumeration(n, enumerationErrors);
        return new ScriptNode(this, (Long)outArg.value, false);
    }

    public ScriptNode runXmlScript(String string) throws GeneralException {
        EnumerationErrors enumerationErrors = new EnumerationErrors();
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnContextRunXmlScriptEx(this.toNative(), string, enumerationErrors.toNative(), outArg);
        WrapperUtils.checkEnumeration(n, enumerationErrors);
        return new ScriptNode(this, (Long)outArg.value, false);
    }

    public Player openFileRecordingEx(String string) throws GeneralException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnContextOpenFileRecordingEx(this.toNative(), string, outArg);
        WrapperUtils.throwOnError(n);
        return (Player)Context.createProductionNodeFromNative((Long)outArg.value);
    }

    public void release() {
        this.dispose();
    }

    public void addLicense(License license) throws StatusException {
        int n = NativeMethods.xnAddLicense(this.toNative(), license.getVendor(), license.getKey());
        WrapperUtils.throwOnError(n);
    }

    public License[] enumerateLicenses() throws StatusException {
        OutArg<License[]> outArg = new OutArg<License[]>();
        int n = NativeMethods.xnEnumerateLicenses(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return (License[])outArg.value;
    }

    public NodeInfoList enumerateProductionTrees(NodeType nodeType, Query query) throws GeneralException {
        EnumerationErrors enumerationErrors = new EnumerationErrors();
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnEnumerateProductionTrees(this.toNative(), nodeType.toNative(), query == null ? 0L : query.toNative(), outArg, enumerationErrors.toNative());
        WrapperUtils.checkEnumeration(n, enumerationErrors);
        return new NodeInfoList((Long)outArg.value);
    }

    public NodeInfoList enumerateProductionTrees(NodeType nodeType) throws GeneralException {
        return this.enumerateProductionTrees(nodeType, null);
    }

    public ProductionNode createProductionTree(NodeInfo nodeInfo) throws GeneralException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnCreateProductionTree(this.toNative(), nodeInfo.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return this.createProductionNodeObject((Long)outArg.value);
    }

    public ProductionNode createAnyProductionTree(NodeType nodeType, Query query) throws GeneralException {
        EnumerationErrors enumerationErrors = new EnumerationErrors();
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnCreateAnyProductionTree(this.toNative(), nodeType.toNative(), query == null ? 0L : query.toNative(), outArg, enumerationErrors.toNative());
        WrapperUtils.checkEnumeration(n, enumerationErrors);
        return Context.createProductionNodeFromNative((Long)outArg.value);
    }

    public NodeInfoList enumerateExistingNodes() throws GeneralException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnEnumerateExistingNodes(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return new NodeInfoList((Long)outArg.value);
    }

    public NodeInfoList enumerateExistingNodes(NodeType nodeType) throws GeneralException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnEnumerateExistingNodesByType(this.toNative(), nodeType.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return new NodeInfoList((Long)outArg.value);
    }

    public ProductionNode findExistingNode(NodeType nodeType) throws GeneralException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnFindExistingRefNodeByType(this.toNative(), nodeType.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        ProductionNode productionNode = this.createProductionNodeObject((Long)outArg.value, nodeType);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return productionNode;
    }

    public ProductionNode getProductionNodeByName(String string) throws GeneralException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnGetRefNodeHandleByName(this.toNative(), string, outArg);
        WrapperUtils.throwOnError(n);
        ProductionNode productionNode = this.createProductionNodeObject((Long)outArg.value);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return productionNode;
    }

    public NodeInfo getProductionNodeInfoByName(String string) throws GeneralException {
        return this.getProductionNodeByName(string).getInfo();
    }

    public void startGeneratingAll() throws StatusException {
        int n = NativeMethods.xnStartGeneratingAll(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void stopGeneratingAll() throws StatusException {
        int n = NativeMethods.xnStopGeneratingAll(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public boolean getGlobalMirror() {
        return NativeMethods.xnGetGlobalMirror(this.toNative());
    }

    public void setGlobalMirror(boolean bl) throws StatusException {
        int n = NativeMethods.xnSetGlobalMirror(this.toNative(), bl);
        WrapperUtils.throwOnError(n);
    }

    public void waitAndUpdateAll() throws StatusException {
        int n = NativeMethods.xnWaitAndUpdateAll(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void waitOneUpdateAll(ProductionNode productionNode) throws StatusException {
        int n = NativeMethods.xnWaitOneUpdateAll(this.toNative(), productionNode.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void waitAnyUpdateAll() throws StatusException {
        int n = NativeMethods.xnWaitAnyUpdateAll(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void waitNoneUpdateAll() throws StatusException {
        int n = NativeMethods.xnWaitNoneUpdateAll(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public IObservable<ErrorStateEventArgs> getErrorStateChangedEvent() {
        return this.errorStateChangedEvent;
    }

    public IObservable<NodeCreatedEventArgs> getNodeCreatedEvent() {
        return this.nodeCreatedEvent;
    }

    public IObservable<NodeDestroyedEventArgs> getNodeDestroyedEvent() {
        return this.nodeDestroyedEvent;
    }

    public static ProductionNode createProductionNodeFromNative(long l) throws GeneralException {
        long l2 = NativeMethods.xnGetRefContextFromNodeHandle(l);
        Context context = Context.fromNative(l2);
        NativeMethods.xnContextRelease(l2);
        return context.createProductionNodeObject(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void freeObject(long l) {
        Hashtable<Long, Context> hashtable = allContexts;
        synchronized (hashtable) {
            allContexts.remove(l);
        }
        NativeMethods.xnContextRelease(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context(long l, boolean bl) throws GeneralException {
        super(l);
        this.errorStateChangedEvent = new Observable<ErrorStateEventArgs>(){

            @Override
            protected int registerNative(OutArg<Long> outArg) throws StatusException {
                return NativeMethods.xnRegisterToGlobalErrorStateChange(Context.this.toNative(), this, "callback", outArg);
            }

            @Override
            protected void unregisterNative(long l) {
                NativeMethods.xnUnregisterFromGlobalErrorStateChange(Context.this.toNative(), l);
            }

            public void callback(int n) {
                this.notify(new ErrorStateEventArgs(n));
            }
        };
        this.nodeCreatedEvent = new Observable<NodeCreatedEventArgs>(){

            @Override
            protected int registerNative(OutArg<Long> outArg) throws StatusException {
                return NativeMethods.xnRegisterToNodeCreation(Context.this.toNative(), this, "callback", outArg);
            }

            @Override
            protected void unregisterNative(long l) {
                NativeMethods.xnUnregisterFromNodeCreation(Context.this.toNative(), l);
            }

            public void callback(long l) throws GeneralException {
                ProductionNode productionNode = Context.this.createProductionNodeObject(l);
                this.notify(new NodeCreatedEventArgs(productionNode));
            }
        };
        this.nodeDestroyedEvent = new Observable<NodeDestroyedEventArgs>(){

            @Override
            protected int registerNative(OutArg<Long> outArg) throws StatusException {
                return NativeMethods.xnRegisterToNodeDestruction(Context.this.toNative(), this, "callback", outArg);
            }

            @Override
            protected void unregisterNative(long l) {
                NativeMethods.xnUnregisterFromNodeDestruction(Context.this.toNative(), l);
            }

            public void callback(String string) throws GeneralException {
                this.notify(new NodeDestroyedEventArgs(string));
            }
        };
        Hashtable<Long, Context> hashtable = allContexts;
        synchronized (hashtable) {
            if (allContexts.containsKey(l)) {
                throw new GeneralException("Java wrapper: creating a Context object wrapping an already wrapped object!");
            }
            allContexts.put(l, this);
        }
        if (bl) {
            WrapperUtils.throwOnError(NativeMethods.xnContextAddRef(l));
        }
    }

    private Context(long l) throws GeneralException {
        this(l, true);
    }

    private static long init() throws StatusException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnInit(outArg);
        WrapperUtils.throwOnError(n);
        return (Long)outArg.value;
    }

    private static long initFromXmlEx(String string, OutArg<Long> outArg) throws StatusException {
        OutArg<Long> outArg2 = new OutArg<Long>();
        int n = NativeMethods.xnInitFromXmlFileEx(string, outArg2, 0L, outArg);
        WrapperUtils.throwOnError(n);
        return (Long)outArg2.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProductionNode createProductionNodeObject(long l, NodeType nodeType) throws GeneralException {
        Hashtable<Long, ProductionNode> hashtable = this.allNodes;
        synchronized (hashtable) {
            if (!this.allNodes.containsKey(l)) {
                ProductionNode productionNode;
                if (nodeType.equals(NodeType.DEVICE)) {
                    productionNode = new Device(this, l, true);
                } else if (nodeType.equals(NodeType.DEPTH)) {
                    productionNode = new DepthGenerator(this, l, true);
                } else if (nodeType.equals(NodeType.IMAGE)) {
                    productionNode = new ImageGenerator(this, l, true);
                } else if (nodeType.equals(NodeType.AUDIO)) {
                    productionNode = new AudioGenerator(this, l, true);
                } else if (nodeType.equals(NodeType.IR)) {
                    productionNode = new IRGenerator(this, l, true);
                } else if (nodeType.equals(NodeType.USER)) {
                    productionNode = new UserGenerator(this, l, true);
                } else if (nodeType.equals(NodeType.RECORDER)) {
                    productionNode = new Recorder(this, l, true);
                } else if (nodeType.equals(NodeType.PLAYER)) {
                    productionNode = new Player(this, l, true);
                } else if (nodeType.equals(NodeType.GESTURE)) {
                    productionNode = new GestureGenerator(this, l, true);
                } else if (nodeType.equals(NodeType.SCENE)) {
                    productionNode = new SceneAnalyzer(this, l, true);
                } else if (nodeType.equals(NodeType.HANDS)) {
                    productionNode = new HandsGenerator(this, l, true);
                } else if (nodeType.equals(NodeType.CODEC)) {
                    productionNode = new Codec(this, l, true);
                } else if (nodeType.equals(NodeType.SCRIPT_NODE)) {
                    productionNode = new ScriptNode(this, l, true);
                } else if (nodeType.equals(NodeType.PRODUCTION_NODE)) {
                    productionNode = new ProductionNode(this, l, true);
                } else if (nodeType.equals(NodeType.GENERATOR)) {
                    productionNode = new Generator(this, l, true);
                } else if (nodeType.equals(NodeType.MAP_GENERATOR)) {
                    productionNode = new MapGenerator(this, l, true);
                } else {
                    throw new GeneralException("java wrapper: Unknown generator type!");
                }
                this.allNodes.put(l, productionNode);
            }
            return this.allNodes.get(l);
        }
    }

    ProductionNode createProductionNodeObject(long l) throws GeneralException {
        long l2 = NativeMethods.xnGetNodeInfo(l);
        NodeType nodeType = NativeMethods.xnNodeInfoGetDescription(l2).getType();
        return this.createProductionNodeObject(l, nodeType);
    }
}

