/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import org.openni.NativeMethods;

public class NodeType {
    public static NodeType INVALID = new NodeType(0);
    public static NodeType DEVICE = new NodeType(1);
    public static NodeType DEPTH = new NodeType(2);
    public static NodeType IMAGE = new NodeType(3);
    public static NodeType AUDIO = new NodeType(4);
    public static NodeType IR = new NodeType(5);
    public static NodeType USER = new NodeType(6);
    public static NodeType RECORDER = new NodeType(7);
    public static NodeType PLAYER = new NodeType(8);
    public static NodeType GESTURE = new NodeType(9);
    public static NodeType SCENE = new NodeType(10);
    public static NodeType HANDS = new NodeType(11);
    public static NodeType CODEC = new NodeType(12);
    public static NodeType PRODUCTION_NODE = new NodeType(13);
    public static NodeType GENERATOR = new NodeType(14);
    public static NodeType MAP_GENERATOR = new NodeType(15);
    public static NodeType SCRIPT_NODE = new NodeType(16);
    private final int val;

    NodeType(int n) {
        this.val = n;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.val;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NodeType nodeType = (NodeType)object;
        return this.val == nodeType.val;
    }

    public int toNative() {
        return this.val;
    }

    public String toString() {
        return NativeMethods.xnProductionNodeTypeToString(this.toNative());
    }

    public boolean isGenerator() {
        return NativeMethods.xnIsTypeGenerator(this.toNative());
    }

    public boolean isDerivedFrom(NodeType nodeType) {
        return NativeMethods.xnIsTypeDerivedFrom(this.toNative(), nodeType.toNative());
    }
}

