/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import java.util.NoSuchElementException;
import org.openni.NativeMethods;

public enum Resolution {
    CUSTOM(0),
    QQVGA(1),
    CGA(2),
    QVGA(3),
    VGA(4),
    SVGA(5),
    XGA(6),
    P720(7),
    SXGA(8),
    UXGA(9),
    P1080(10);

    private final int val;
    private final int xRes;
    private final int yRes;
    private final String name;

    private Resolution(int n2) {
        this.val = n2;
        this.xRes = NativeMethods.xnResolutionGetXRes(n2);
        this.yRes = NativeMethods.xnResolutionGetYRes(n2);
        this.name = NativeMethods.xnResolutionGetName(n2);
    }

    public int getxRes() {
        return this.xRes;
    }

    public int getyRes() {
        return this.yRes;
    }

    public String getName() {
        return this.name;
    }

    public int toNative() {
        return this.val;
    }

    public static Resolution fromNative(int n) {
        for (Resolution resolution : Resolution.values()) {
            if (resolution.val != n) continue;
            return resolution;
        }
        throw new NoSuchElementException();
    }

    public static Resolution fromName(String string) {
        return Resolution.fromNative(NativeMethods.xnResolutionGetFromName(string));
    }

    public static Resolution fromXYRes(int n, int n2) {
        return Resolution.fromNative(NativeMethods.xnResolutionGetFromXYRes(n, n2));
    }
}

