/*
 * Decompiled with CFR 0.152.
 */
package org.openni;

import org.openni.ActiveHandEventArgs;
import org.openni.Context;
import org.openni.EnumerationErrors;
import org.openni.GeneralException;
import org.openni.Generator;
import org.openni.HandTouchingFOVEdgeCapability;
import org.openni.IObservable;
import org.openni.InactiveHandEventArgs;
import org.openni.NativeMethods;
import org.openni.NodeType;
import org.openni.Observable;
import org.openni.OutArg;
import org.openni.Point3D;
import org.openni.Query;
import org.openni.StatusException;
import org.openni.WrapperUtils;

public class HandsGenerator
extends Generator {
    private Observable<ActiveHandEventArgs> handCreateEvent = new Observable<ActiveHandEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> outArg) throws StatusException {
            return NativeMethods.xnRegisterHandCallbacks(HandsGenerator.this.toNative(), this, "callback", null, null, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterHandCallbacks(HandsGenerator.this.toNative(), l);
        }

        public void callback(int n, Point3D point3D, float f) {
            this.notify(new ActiveHandEventArgs(n, point3D, f));
        }
    };
    private Observable<ActiveHandEventArgs> handUpdateEvent = new Observable<ActiveHandEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> outArg) throws StatusException {
            return NativeMethods.xnRegisterHandCallbacks(HandsGenerator.this.toNative(), this, null, "callback", null, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterHandCallbacks(HandsGenerator.this.toNative(), l);
        }

        public void callback(int n, Point3D point3D, float f) {
            this.notify(new ActiveHandEventArgs(n, point3D, f));
        }
    };
    private Observable<InactiveHandEventArgs> handDestroyEvent = new Observable<InactiveHandEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> outArg) throws StatusException {
            return NativeMethods.xnRegisterHandCallbacks(HandsGenerator.this.toNative(), this, null, null, "callback", outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterHandCallbacks(HandsGenerator.this.toNative(), l);
        }

        public void callback(int n, float f) {
            this.notify(new InactiveHandEventArgs(n, f));
        }
    };

    HandsGenerator(Context context, long l, boolean bl) throws GeneralException {
        super(context, l, bl);
    }

    public static HandsGenerator create(Context context, Query query, EnumerationErrors enumerationErrors) throws GeneralException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnCreateHandsGenerator(context.toNative(), outArg, query == null ? 0L : query.toNative(), enumerationErrors == null ? 0L : enumerationErrors.toNative());
        WrapperUtils.throwOnError(n);
        HandsGenerator handsGenerator = (HandsGenerator)context.createProductionNodeObject((Long)outArg.value, NodeType.HANDS);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return handsGenerator;
    }

    public static HandsGenerator create(Context context, Query query) throws GeneralException {
        return HandsGenerator.create(context, query, null);
    }

    public static HandsGenerator create(Context context) throws GeneralException {
        return HandsGenerator.create(context, null, null);
    }

    public void StopTracking(int n) throws StatusException {
        int n2 = NativeMethods.xnStopTracking(this.toNative(), n);
        WrapperUtils.throwOnError(n2);
    }

    public void StopTrackingAll() throws StatusException {
        int n = NativeMethods.xnStopTrackingAll(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void StartTracking(Point3D point3D) throws StatusException {
        int n = NativeMethods.xnStartTracking(this.toNative(), point3D.getX(), point3D.getY(), point3D.getZ());
        WrapperUtils.throwOnError(n);
    }

    public void SetSmoothing(float f) throws StatusException {
        int n = NativeMethods.xnSetTrackingSmoothing(this.toNative(), f);
        WrapperUtils.throwOnError(n);
    }

    public HandTouchingFOVEdgeCapability getHandTouchingFOVEdgeCapability() throws StatusException {
        return new HandTouchingFOVEdgeCapability(this);
    }

    public IObservable<ActiveHandEventArgs> getHandCreateEvent() {
        return this.handCreateEvent;
    }

    public IObservable<ActiveHandEventArgs> getHandUpdateEvent() {
        return this.handUpdateEvent;
    }

    public IObservable<InactiveHandEventArgs> getHandDestroyEvent() {
        return this.handDestroyEvent;
    }
}

